/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ClassFileUtilities {
    public static final byte CONSTANT_UTF8_INFO = 1;
    public static final byte CONSTANT_INTEGER_INFO = 3;
    public static final byte CONSTANT_FLOAT_INFO = 4;
    public static final byte CONSTANT_LONG_INFO = 5;
    public static final byte CONSTANT_DOUBLE_INFO = 6;
    public static final byte CONSTANT_CLASS_INFO = 7;
    public static final byte CONSTANT_STRING_INFO = 8;
    public static final byte CONSTANT_FIELDREF_INFO = 9;
    public static final byte CONSTANT_METHODREF_INFO = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF_INFO = 11;
    public static final byte CONSTANT_NAMEANDTYPE_INFO = 12;

    protected ClassFileUtilities() {
    }

    public static Set getClassDependencies(String path, Set classpath) throws IOException {
        FileInputStream is = new FileInputStream(path);
        HashSet result = new HashSet();
        HashSet done = new HashSet();
        ClassFileUtilities.computeClassDependencies(is, classpath, done, result);
        return result;
    }

    private static void computeClassDependencies(InputStream is, Set classpath, Set done, Set result) throws IOException {
        Iterator it = ClassFileUtilities.getClassDependencies(is).iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (done.contains(s)) continue;
            done.add(s);
            Iterator cpit = classpath.iterator();
            while (cpit.hasNext()) {
                String root = (String)cpit.next();
                StringBuffer sb = new StringBuffer(root);
                sb.append('/').append(s).append(".class");
                String path = sb.toString();
                File f = new File(path);
                if (!f.isFile()) continue;
                result.add(path);
                ClassFileUtilities.computeClassDependencies(new FileInputStream(f), classpath, done, result);
            }
        }
    }

    public static Set getClassDependencies(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        if (dis.readInt() != -889275714) {
            throw new IOException("Invalid classfile");
        }
        dis.readInt();
        int len = dis.readShort();
        String[] strs = new String[len];
        HashSet<Integer> classes = new HashSet<Integer>();
        HashSet<Integer> desc = new HashSet<Integer>();
        int i = 1;
        while (i < len) {
            switch (dis.readByte() & 0xFF) {
                case 5: 
                case 6: {
                    dis.readLong();
                    ++i;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    dis.readInt();
                    break;
                }
                case 7: {
                    classes.add(new Integer(dis.readShort() & 0xFFFF));
                    break;
                }
                case 8: {
                    dis.readShort();
                    break;
                }
                case 12: {
                    dis.readShort();
                    desc.add(new Integer(dis.readShort() & 0xFFFF));
                    break;
                }
                case 1: {
                    strs[i] = dis.readUTF();
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ++i;
        }
        HashSet<String> result = new HashSet<String>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            result.add(strs[(Integer)it.next()]);
        }
        it = desc.iterator();
        while (it.hasNext()) {
            result.addAll(ClassFileUtilities.getDescriptorClasses(strs[(Integer)it.next()]));
        }
        return result;
    }

    protected static Set getDescriptorClasses(String desc) {
        HashSet<String> result = new HashSet<String>();
        int i = 0;
        char c = desc.charAt(i);
        block0 : switch (c) {
            case '(': {
                StringBuffer sb;
                block14: while (true) {
                    c = desc.charAt(++i);
                    switch (c) {
                        case '[': {
                            while ((c = desc.charAt(++i)) == '[') {
                            }
                            if (c != 'L') continue block14;
                        }
                        case 'L': {
                            c = desc.charAt(++i);
                            sb = new StringBuffer();
                            while (c != ';') {
                                sb.append(c);
                                c = desc.charAt(++i);
                            }
                            result.add(sb.toString());
                            break;
                        }
                        default: {
                            break;
                        }
                        case ')': {
                            break block14;
                        }
                    }
                }
                c = desc.charAt(++i);
                switch (c) {
                    case '[': {
                        while ((c = desc.charAt(++i)) == '[') {
                        }
                        if (c != 'L') break block0;
                    }
                    case 'L': {
                        c = desc.charAt(++i);
                        sb = new StringBuffer();
                        while (c != ';') {
                            sb.append(c);
                            c = desc.charAt(++i);
                        }
                        result.add(sb.toString());
                        break;
                    }
                }
                break;
            }
            case '[': {
                while ((c = desc.charAt(++i)) == '[') {
                }
                if (c != 'L') break;
            }
            case 'L': {
                c = desc.charAt(++i);
                StringBuffer sb = new StringBuffer();
                while (c != ';') {
                    sb.append(c);
                    c = desc.charAt(++i);
                }
                result.add(sb.toString());
                break;
            }
        }
        return result;
    }
}

