/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.search;

import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsDataObj;
import edu.uiowa.physics.pw.pds.base.PdsNumericObj;
import edu.uiowa.physics.pw.pds.base.PdsRangeException;
import edu.uiowa.physics.pw.pds.search.PDS_SEARCH_TYPE;
import edu.uiowa.physics.pw.pds.search.PdsRowList;
import edu.uiowa.physics.pw.pds.search.PdsTblSearcher;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import pds.label.PDSException;
import pds.util.PPITime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsSimpleTblSearcher
implements PdsTblSearcher {
    private PdsDataObj m_tbl;
    private SortedMap<String, PDS_SEARCH_TYPE> m_colTypes;
    private Map<String, TreeMap<String, HashSet<Integer>>> m_strCols;
    private Map<String, TreeMap<Double, HashSet<Integer>>> m_numCols;
    private Map<String, TreeMap<PPITime, HashSet<Integer>>> m_timeCols;

    public PdsSimpleTblSearcher(PdsDataObj table, List<String> exclude) {
        this.m_tbl = table;
        this.m_colTypes = new TreeMap<String, PDS_SEARCH_TYPE>();
        this.m_numCols = new HashMap<String, TreeMap<Double, HashSet<Integer>>>();
        this.m_strCols = new HashMap<String, TreeMap<String, HashSet<Integer>>>();
        this.m_timeCols = new HashMap<String, TreeMap<PPITime, HashSet<Integer>>>();
        block5: for (PdsChildObj obj : table.objectValues()) {
            if (!(obj instanceof PdsNumericObj) || exclude.contains(obj.getName())) continue;
            PdsNumericObj col = (PdsNumericObj)obj;
            String sColName = col.getName();
            PDS_SEARCH_TYPE nSearchType = PDS_SEARCH_TYPE.map(col.getDataType());
            this.m_colTypes.put(sColName, nSearchType);
            switch (nSearchType) {
                case NUMERIC: {
                    this.m_numCols.put(sColName, null);
                    continue block5;
                }
                case STRING: {
                    this.m_strCols.put(sColName, null);
                    continue block5;
                }
                case TIME: {
                    this.m_timeCols.put(sColName, null);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Search on " + (Object)((Object)nSearchType) + "columns" + " not implemented.  hint: add column " + sColName + "to the exclude" + " list in the contructor");
        }
    }

    @Override
    public Map<String, PDS_SEARCH_TYPE> getSearchCols() {
        return new HashMap<String, PDS_SEARCH_TYPE>(this.m_colTypes);
    }

    @Override
    public PdsRowList all() {
        return new PdsRowList(this.m_tbl.size());
    }

    protected TreeMap<Double, HashSet<Integer>> readNumericCol(String sColName) throws PDSException, PdsRangeException, IOException {
        TreeMap<Double, HashSet<Integer>> dMap = new TreeMap<Double, HashSet<Integer>>();
        PdsNumericObj col = (PdsNumericObj)this.m_tbl.sub(sColName);
        col.setItem(0);
        for (int i = 0; i < this.m_tbl.size(); ++i) {
            this.m_tbl.setRow(i);
            Double d = col.doubleVal();
            if (!dMap.containsKey(d)) {
                HashSet<Integer> rowSet = new HashSet<Integer>();
                rowSet.add(i);
                dMap.put(d, rowSet);
                continue;
            }
            dMap.get(d).add(i);
        }
        return dMap;
    }

    protected TreeMap<String, HashSet<Integer>> readStringCol(String sColName) throws PDSException, IOException {
        TreeMap<String, HashSet<Integer>> sMap = new TreeMap<String, HashSet<Integer>>();
        PdsNumericObj col = (PdsNumericObj)this.m_tbl.sub(sColName);
        col.setItem(0);
        for (int i = 0; i < this.m_tbl.size(); ++i) {
            this.m_tbl.setRow(i);
            String s = col.getString();
            if (!sMap.containsKey(s)) {
                HashSet<Integer> rowSet = new HashSet<Integer>();
                rowSet.add(i);
                sMap.put(s, rowSet);
                continue;
            }
            sMap.get(s).add(i);
        }
        return sMap;
    }

    protected TreeMap<PPITime, HashSet<Integer>> readTimeCol(String sColName) throws PDSException, IOException {
        TreeMap<PPITime, HashSet<Integer>> tMap = new TreeMap<PPITime, HashSet<Integer>>();
        PdsNumericObj col = (PdsNumericObj)this.m_tbl.sub(sColName);
        col.setItem(0);
        for (int i = 0; i < this.m_tbl.size(); ++i) {
            this.m_tbl.setRow(i);
            PPITime t = new PPITime();
            String sTmp = col.getString();
            if (!t.convert("T", sTmp)) {
                throw new PDSException(this.m_tbl.getLabelRelPath() + ": Couldn't read '" + sTmp + "' as a PDS time string.");
            }
            if (!tMap.containsKey(t)) {
                HashSet<Integer> rowSet = new HashSet<Integer>();
                rowSet.add(i);
                tMap.put(t, rowSet);
                continue;
            }
            tMap.get(t).add(i);
        }
        return tMap;
    }

    private TreeMap<Double, HashSet<Integer>> getNumMap(String sCol) throws PDSException, PdsRangeException, IOException {
        if (!this.m_numCols.containsKey(sCol)) {
            throw new IllegalArgumentException(this.m_tbl.getLabelRelPath() + " does not contain" + " a numeric column named " + sCol);
        }
        TreeMap<Double, HashSet<Integer>> dMap = this.m_numCols.get(sCol);
        if (dMap == null) {
            this.m_numCols.put(sCol, this.readNumericCol(sCol));
            dMap = this.m_numCols.get(sCol);
        }
        return dMap;
    }

    @Override
    public PdsRowList findEq(String sColName, Double dVal) throws PDSException, PdsRangeException, IOException {
        TreeMap<Double, HashSet<Integer>> daMap = this.getNumMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        if (daMap.containsKey(dVal)) {
            for (Integer nRow : daMap.get(dVal)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findNe(String sColName, Double dVal) throws PDSException, PdsRangeException, IOException {
        TreeMap<Double, HashSet<Integer>> daMap = this.getNumMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        for (Double tblValue : daMap.keySet()) {
            if (tblValue.equals(dVal)) continue;
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findGt(String sColName, Double dVal) throws PDSException, PdsRangeException, IOException {
        TreeMap<Double, HashSet<Integer>> daMap = this.getNumMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<Double, HashSet<Integer>> tailMap = daMap.tailMap(dVal);
        for (Double tblValue : tailMap.keySet()) {
            if (tblValue.equals(dVal)) continue;
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findLt(String sColName, Double dVal) throws PDSException, PdsRangeException, IOException {
        TreeMap<Double, HashSet<Integer>> daMap = this.getNumMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<Double, HashSet<Integer>> headMap = daMap.headMap(dVal);
        for (Double tblValue : headMap.keySet()) {
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findGtEq(String sColName, Double dVal) throws PDSException, PdsRangeException, IOException {
        TreeMap<Double, HashSet<Integer>> daMap = this.getNumMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<Double, HashSet<Integer>> tailMap = daMap.tailMap(dVal);
        for (Double tblValue : tailMap.keySet()) {
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findLtEq(String sColName, Double dVal) throws PDSException, PdsRangeException, IOException {
        TreeMap<Double, HashSet<Integer>> daMap = this.getNumMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<Double, HashSet<Integer>> headMap = daMap.headMap(dVal);
        for (Double tblValue : headMap.keySet()) {
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        if (daMap.containsKey(dVal)) {
            for (Integer nRow : daMap.get(dVal)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    private TreeMap<String, HashSet<Integer>> getStrMap(String sCol) throws PDSException, IOException {
        if (!this.m_strCols.containsKey(sCol)) {
            throw new IllegalArgumentException(this.m_tbl.getName() + " does not contain a " + "character column named " + sCol);
        }
        TreeMap<String, HashSet<Integer>> sMap = this.m_strCols.get(sCol);
        if (sMap == null) {
            this.m_strCols.put(sCol, this.readStringCol(sCol));
            sMap = this.m_strCols.get(sCol);
        }
        return sMap;
    }

    @Override
    public PdsRowList findEq(String sColName, String sVal) throws PDSException, IOException {
        TreeMap<String, HashSet<Integer>> daMap = this.getStrMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        if (daMap.containsKey(sVal)) {
            for (Integer nRow : daMap.get(sVal)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findNe(String sColName, String sVal) throws PDSException, IOException {
        TreeMap<String, HashSet<Integer>> daMap = this.getStrMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        for (String tblValue : daMap.keySet()) {
            if (tblValue.equals(sVal)) continue;
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findGt(String sColName, String sVal) throws PDSException, IOException {
        TreeMap<String, HashSet<Integer>> daMap = this.getStrMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<String, HashSet<Integer>> tailMap = daMap.tailMap(sVal);
        for (String tblValue : tailMap.keySet()) {
            if (tblValue.equals(sVal)) continue;
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findLt(String sColName, String sVal) throws PDSException, IOException {
        TreeMap<String, HashSet<Integer>> daMap = this.getStrMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<String, HashSet<Integer>> headMap = daMap.headMap(sVal);
        for (String tblValue : headMap.keySet()) {
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findGtEq(String sColName, String sVal) throws PDSException, IOException {
        TreeMap<String, HashSet<Integer>> daMap = this.getStrMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<String, HashSet<Integer>> tailMap = daMap.tailMap(sVal);
        for (String tblValue : tailMap.keySet()) {
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findLtEq(String sColName, String sVal) throws PDSException, IOException {
        TreeMap<String, HashSet<Integer>> daMap = this.getStrMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<String, HashSet<Integer>> headMap = daMap.headMap(sVal);
        for (String tblValue : headMap.keySet()) {
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        if (daMap.containsKey(sVal)) {
            for (Integer nRow : daMap.get(sVal)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList match(String sColName) throws PDSException, IOException {
        TreeMap<String, HashSet<Integer>> daMap = this.getStrMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        throw new UnsupportedOperationException("Regex matching not yet implemented");
    }

    private TreeMap<PPITime, HashSet<Integer>> getTimeMap(String sCol) throws PDSException, IOException {
        if (!this.m_timeCols.containsKey(sCol)) {
            throw new IllegalArgumentException(this.m_tbl.getName() + " does not contain a " + "time column named " + sCol);
        }
        TreeMap<PPITime, HashSet<Integer>> tMap = this.m_timeCols.get(sCol);
        if (tMap == null) {
            this.m_timeCols.put(sCol, this.readTimeCol(sCol));
            tMap = this.m_timeCols.get(sCol);
        }
        return tMap;
    }

    @Override
    public PdsRowList findEq(String sColName, PPITime tVal) throws PDSException, IOException {
        TreeMap<PPITime, HashSet<Integer>> daMap = this.getTimeMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        if (daMap.containsKey(tVal)) {
            for (Integer nRow : daMap.get(tVal)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findNe(String sColName, PPITime tVal) throws PDSException, IOException {
        TreeMap<PPITime, HashSet<Integer>> daMap = this.getTimeMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        for (PPITime tblValue : daMap.keySet()) {
            if (tblValue.equals(tVal)) continue;
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findGt(String sColName, PPITime tVal) throws PDSException, IOException {
        TreeMap<PPITime, HashSet<Integer>> daMap = this.getTimeMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<PPITime, HashSet<Integer>> tailMap = daMap.tailMap(tVal);
        for (PPITime tblValue : tailMap.keySet()) {
            if (tblValue.equals(tVal)) continue;
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findLt(String sColName, PPITime tVal) throws PDSException, IOException {
        TreeMap<PPITime, HashSet<Integer>> daMap = this.getTimeMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<PPITime, HashSet<Integer>> headMap = daMap.headMap(tVal);
        for (PPITime tblValue : headMap.keySet()) {
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findGtEq(String sColName, PPITime tVal) throws PDSException, IOException {
        TreeMap<PPITime, HashSet<Integer>> daMap = this.getTimeMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<PPITime, HashSet<Integer>> tailMap = daMap.tailMap(tVal);
        for (PPITime tblValue : tailMap.keySet()) {
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }

    @Override
    public PdsRowList findLtEq(String sColName, PPITime tVal) throws PDSException, IOException {
        TreeMap<PPITime, HashSet<Integer>> daMap = this.getTimeMap(sColName);
        PdsRowList rlRet = new PdsRowList();
        SortedMap<PPITime, HashSet<Integer>> headMap = daMap.headMap(tVal);
        for (PPITime tblValue : headMap.keySet()) {
            for (Integer nRow : daMap.get(tblValue)) {
                rlRet.addRow((int)nRow);
            }
        }
        if (daMap.containsKey(tVal)) {
            for (Integer nRow : daMap.get(tVal)) {
                rlRet.addRow((int)nRow);
            }
        }
        return rlRet;
    }
}

