/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsRowList
implements Iterable<Integer>,
Iterator<Integer> {
    private int m_iNext = 0;
    private List<Integer> m_rows = null;

    public PdsRowList() {
        this.m_rows = new ArrayList<Integer>();
    }

    public PdsRowList(int nRows) {
        this.m_rows = new ArrayList<Integer>(nRows);
        for (int i = 0; i < nRows; ++i) {
            this.m_rows.set(i, i);
        }
    }

    public void addRow(Integer iRow) {
        if (!this.m_rows.contains(iRow)) {
            this.m_rows.add(iRow);
        }
    }

    public PdsRowList NOT_IN(PdsRowList other) {
        Iterator<Integer> i = this.m_rows.iterator();
        while (i.hasNext()) {
            if (!other.m_rows.contains(i.next())) continue;
            i.remove();
        }
        return this;
    }

    public PdsRowList AND(PdsRowList other) {
        Iterator<Integer> i = this.m_rows.iterator();
        while (i.hasNext()) {
            if (other.m_rows.contains(i.next())) continue;
            i.remove();
        }
        return this;
    }

    public PdsRowList OR(PdsRowList rl) {
        for (Integer n : rl.m_rows) {
            this.addRow(n);
        }
        return this;
    }

    @Override
    public Iterator<Integer> iterator() {
        this.m_iNext = 0;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.m_iNext < this.m_rows.size();
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() called for PdsRowList iterator, but there is not a next element.");
        }
        Integer nRet = this.m_rows.get(this.m_iNext);
        ++this.m_iNext;
        return nRet;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("PdsRowList iterators do not allow removal");
    }

    public String toString() {
        if (this.m_rows.size() != 0) {
            return this.m_rows.size() + " rows, first " + this.m_rows.get(0) + " last " + this.m_rows.get(this.m_rows.size() - 1);
        }
        return this.m_rows.size() + " rows";
    }
}

