/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.conv;

import edu.uiowa.physics.pw.pds.base.PdsRangeException;
import edu.uiowa.physics.pw.pds.conv.PdsParserIOdef;
import edu.uiowa.physics.pw.pds.conv.PdsValGetter;
import edu.uiowa.physics.pw.pds.conv.VAL_TYPE;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import pds.label.PDSException;

public abstract class PdsValParser
implements PdsValGetter {
    protected static final BigDecimal BIG_DEC_ZERO = new BigDecimal(0.0);
    protected static final Float FLOAT_ZERO = new Float(0.0);
    protected static final Double DOUBLE_ZERO = new Double(0.0);
    protected PdsParserIOdef m_ioDef;

    protected PdsValParser(PdsParserIOdef ioDef) {
        this.m_ioDef = ioDef;
    }

    public VAL_TYPE getOutType() {
        return this.m_ioDef.getOutType();
    }

    public abstract Object get(byte[] var1) throws PdsRangeException, IndexOutOfBoundsException, PDSException;

    protected String bytes2Str(byte[] b) throws PDSException, IndexOutOfBoundsException {
        String s;
        try {
            s = new String(b, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new PDSException("What!, This platform does not support ASCII?");
        }
        if (s.length() < 1) {
            throw new IndexOutOfBoundsException("Integer strings require at least 1 byte");
        }
        if ((s = s.trim()).length() < 1) {
            throw new PDSException("Integer string contains only whitespace");
        }
        return s;
    }

    protected void ckLength(byte[] b) {
        if (b.length < this.m_ioDef.getPdsTypeSize()) {
            throw new IndexOutOfBoundsException("byte array too short for conversion from " + this.m_ioDef.getPdsType() + ":" + this.m_ioDef.getPdsTypeSize());
        }
    }

    public class PdsNotParsableException
    extends Exception {
        public PdsNotParsableException(String msg) {
            super(msg);
        }

        public PdsNotParsableException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

