/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.conv;

import edu.uiowa.physics.pw.pds.conv.PdsAc2cbdParser;
import edu.uiowa.physics.pw.pds.conv.PdsAdapterCreator;
import edu.uiowa.physics.pw.pds.conv.PdsAdapterIOdef;
import edu.uiowa.physics.pw.pds.conv.PdsAi2cbdParser;
import edu.uiowa.physics.pw.pds.conv.PdsAr2cbdParser;
import edu.uiowa.physics.pw.pds.conv.PdsCbd2bdAdapter;
import edu.uiowa.physics.pw.pds.conv.PdsCbd2biAdapter;
import edu.uiowa.physics.pw.pds.conv.PdsCbd2cdAdapter;
import edu.uiowa.physics.pw.pds.conv.PdsCbd2cfAdapter;
import edu.uiowa.physics.pw.pds.conv.PdsCbd2dAdapter;
import edu.uiowa.physics.pw.pds.conv.PdsCbd2fAdapter;
import edu.uiowa.physics.pw.pds.conv.PdsCbd2iAdapter;
import edu.uiowa.physics.pw.pds.conv.PdsCbd2lAdapter;
import edu.uiowa.physics.pw.pds.conv.PdsIr2fParser;
import edu.uiowa.physics.pw.pds.conv.PdsLi2iParser;
import edu.uiowa.physics.pw.pds.conv.PdsMi2iParser;
import edu.uiowa.physics.pw.pds.conv.PdsMui2iParser;
import edu.uiowa.physics.pw.pds.conv.PdsMui2lParser;
import edu.uiowa.physics.pw.pds.conv.PdsParserCreator;
import edu.uiowa.physics.pw.pds.conv.PdsParserIOdef;
import edu.uiowa.physics.pw.pds.conv.PdsValAdapter;
import edu.uiowa.physics.pw.pds.conv.PdsValGetter;
import edu.uiowa.physics.pw.pds.conv.PdsValParser;
import edu.uiowa.physics.pw.pds.conv.VAL_TYPE;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class PdsGetterMaker {
    protected static final SortedMap<PdsParserIOdef, PdsParserCreator> g_parserMap = new TreeMap<PdsParserIOdef, PdsParserCreator>();
    protected static final Map<PdsAdapterIOdef, PdsAdapterCreator> g_adapterMap = new HashMap<PdsAdapterIOdef, PdsAdapterCreator>();

    public static PdsValGetter mk(String sPdsType, int nSize, VAL_TYPE outType) throws UnsupportedOperationException, IllegalArgumentException {
        if (outType.equals((Object)VAL_TYPE.NOT_A_TYPE)) {
            throw new IllegalArgumentException("outType must not be PDS_OUT_TYPE.NOT_A_TYPE");
        }
        PdsParserIOdef directKey = new PdsParserIOdef(sPdsType, nSize, outType);
        if (g_parserMap.containsKey(directKey)) {
            return ((PdsParserCreator)g_parserMap.get(directKey)).create(directKey);
        }
        PdsParserIOdef firstKey = new PdsParserIOdef(sPdsType, nSize, VAL_TYPE.NOT_A_TYPE);
        PdsParserIOdef lastKey = new PdsParserIOdef(sPdsType, nSize, null);
        SortedMap<PdsParserIOdef, PdsParserCreator> subMap = g_parserMap.subMap(firstKey, lastKey);
        if (subMap.size() < 1) {
            throw new UnsupportedOperationException("No parser for valid PDS type " + directKey.getPdsType() + ":" + directKey.getPdsTypeSize() + " found.");
        }
        for (PdsParserIOdef parserDef : subMap.keySet()) {
            PdsAdapterIOdef adaptDef = new PdsAdapterIOdef(parserDef.getOutType(), outType);
            if (!g_adapterMap.containsKey(adaptDef)) continue;
            PdsValParser parser = ((PdsParserCreator)g_parserMap.get(parserDef)).create(parserDef);
            PdsValAdapter adapter = g_adapterMap.get(adaptDef).create(parser);
            return adapter;
        }
        throw new UnsupportedOperationException("No adapter could be found to convert the output for PDS type " + directKey.getPdsType() + ":" + directKey.getPdsTypeSize() + " to a " + (Object)((Object)outType));
    }

    public static PdsParserCreator addParser(PdsParserIOdef ioDef, PdsParserCreator creator) {
        if (g_parserMap.containsKey(ioDef)) {
            PdsParserCreator previous = (PdsParserCreator)g_parserMap.get(ioDef);
            g_parserMap.put(ioDef, creator);
            return previous;
        }
        g_parserMap.put(ioDef, creator);
        return null;
    }

    public static boolean hasParser(PdsParserIOdef ioDef) {
        return g_parserMap.containsKey(ioDef);
    }

    public static PdsAdapterCreator addAdapter(PdsAdapterIOdef ioDef, PdsAdapterCreator creator) {
        if (g_adapterMap.containsKey(ioDef)) {
            PdsAdapterCreator previous = g_adapterMap.get(ioDef);
            g_adapterMap.put(ioDef, creator);
            return previous;
        }
        g_adapterMap.put(ioDef, creator);
        return null;
    }

    public static boolean hasAdapter(PdsAdapterIOdef ioDef) {
        return g_adapterMap.containsKey(ioDef);
    }

    static {
        g_parserMap.put(PdsAi2cbdParser.ioDef, PdsAi2cbdParser.creator);
        g_parserMap.put(PdsAr2cbdParser.ioDef, PdsAr2cbdParser.creator);
        g_parserMap.put(PdsAc2cbdParser.ioDef, PdsAc2cbdParser.creator);
        g_parserMap.put(PdsMi2iParser.ioDef1, PdsMi2iParser.creator);
        g_parserMap.put(PdsMi2iParser.ioDef2, PdsMi2iParser.creator);
        g_parserMap.put(PdsMi2iParser.ioDef4, PdsMi2iParser.creator);
        g_parserMap.put(PdsLi2iParser.ioDef1, PdsLi2iParser.creator);
        g_parserMap.put(PdsLi2iParser.ioDef2, PdsLi2iParser.creator);
        g_parserMap.put(PdsLi2iParser.ioDef4, PdsLi2iParser.creator);
        g_parserMap.put(PdsMui2iParser.ioDef1, PdsMui2iParser.creator);
        g_parserMap.put(PdsMui2iParser.ioDef2, PdsMui2iParser.creator);
        g_parserMap.put(PdsMui2lParser.ioDef4, PdsMui2lParser.creator);
        g_parserMap.put(PdsIr2fParser.ioDef, PdsIr2fParser.creator);
        g_adapterMap.put(PdsCbd2bdAdapter.ioDef, PdsCbd2bdAdapter.creator);
        g_adapterMap.put(PdsCbd2biAdapter.ioDef, PdsCbd2biAdapter.creator);
        g_adapterMap.put(PdsCbd2cdAdapter.ioDef, PdsCbd2cdAdapter.creator);
        g_adapterMap.put(PdsCbd2cfAdapter.ioDef, PdsCbd2cfAdapter.creator);
        g_adapterMap.put(PdsCbd2dAdapter.ioDef, PdsCbd2dAdapter.creator);
        g_adapterMap.put(PdsCbd2fAdapter.ioDef, PdsCbd2fAdapter.creator);
        g_adapterMap.put(PdsCbd2iAdapter.ioDef, PdsCbd2iAdapter.creator);
        g_adapterMap.put(PdsCbd2lAdapter.ioDef, PdsCbd2lAdapter.creator);
    }
}

