/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.conv;

import edu.uiowa.physics.pw.pds.base.PdsRangeException;
import edu.uiowa.physics.pw.pds.base.TwoNum;
import edu.uiowa.physics.pw.pds.conv.PdsParserCreator;
import edu.uiowa.physics.pw.pds.conv.PdsParserIOdef;
import edu.uiowa.physics.pw.pds.conv.PdsValParser;
import edu.uiowa.physics.pw.pds.conv.VAL_TYPE;
import java.math.BigDecimal;
import pds.label.PDSException;

public class PdsAr2cbdParser
extends PdsValParser {
    static Creator creator = new Creator();
    public static PdsParserIOdef ioDef = new PdsParserIOdef("ASCII_REAL", 1, VAL_TYPE.COMP_BIG_DEC);

    public PdsAr2cbdParser(PdsParserIOdef ioDef) {
        super(ioDef);
        if (ioDef.getOutType() != VAL_TYPE.COMP_BIG_DEC || !ioDef.getPdsType().equals("ASCII_REAL")) {
            throw new IllegalArgumentException("Inproper output type specification for parser PdsAr2cbdParser.");
        }
    }

    public Object get(byte[] b) throws PdsRangeException, IndexOutOfBoundsException, PDSException {
        BigDecimal bdReal;
        try {
            bdReal = new BigDecimal(this.bytes2Str(b));
        }
        catch (NumberFormatException e) {
            throw new PDSException(e.getMessage());
        }
        return new TwoNum<BigDecimal>(bdReal, BIG_DEC_ZERO);
    }

    static class Creator
    implements PdsParserCreator {
        Creator() {
        }

        public PdsValParser create(PdsParserIOdef ioDef) {
            return new PdsAr2cbdParser(ioDef);
        }
    }
}

