/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.catalog;

import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.base.PdsObjCreator;
import edu.uiowa.physics.pw.pds.catalog.PdsDataSet;
import java.util.ArrayList;
import java.util.List;
import pds.label.PDSElement;
import pds.label.PDSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsDataSetInformation
extends PdsChildObj {
    public static PdsObjCreator creator = new Creator();
    public static List<String> g_allowedElements = new ArrayList<String>();
    public static List<String> g_reqElements = new ArrayList<String>();
    public static List<Class> g_allowedObjects = new ArrayList<Class>();
    public static List<Class> g_reqObjects = new ArrayList<Class>();

    protected PdsDataSetInformation(String sType, PdsObj parent) throws PDSException {
        super(sType, parent);
    }

    @Override
    protected boolean isElementAllowed(String sElementName) {
        return g_allowedElements.contains(sElementName);
    }

    @Override
    protected boolean isObjectAllowed(Class childClass) {
        return g_allowedObjects.contains(childClass);
    }

    @Override
    protected List<String> getRequiredElements() {
        return g_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return g_reqObjects;
    }

    @Override
    public boolean addElement(PDSElement el) throws PDSException {
        if (!super.addElement(el)) {
            return false;
        }
        String sKey = el.mKeyword;
        if (sKey.equals("DATA_SET_NAME")) {
            this.m_sName = el.value(0);
        }
        return true;
    }

    static {
        g_reqElements.add("ABSTRACT_DESC");
        g_reqElements.add("CITATION_DESC");
        g_reqElements.add("CONFIDENCE_LEVEL_NOTE");
        g_reqElements.add("DATA_OBJECT_TYPE");
        g_reqElements.add("DATA_SET_COLLECTION_MEMBER_FLG");
        g_reqElements.add("DATA_SET_DESC");
        g_reqElements.add("DATA_SET_NAME");
        g_reqElements.add("DATA_SET_RELEASE_DATE");
        g_reqElements.add("DATA_SET_TERSE_DESC");
        g_reqElements.add("DETAILED_CATALOG_FLAG");
        g_reqElements.add("PRODUCER_FULL_NAME");
        g_reqElements.add("START_TIME");
        g_reqElements.add("STOP_TIME");
        g_allowedElements.addAll(g_reqElements);
        g_allowedElements.add("ARCHIVE_STATUS");
    }

    private static class Creator
    implements PdsObjCreator {
        private Creator() {
        }

        public PdsObj create(PdsObj parent) throws PDSException {
            if (parent instanceof PdsDataSet) {
                return new PdsDataSetInformation("DATA_SET_INFORMATION", parent);
            }
            throw new PDSException("The parent of a DATA_SET_INFORMATION object must be a type of DATA_SET not a " + parent.getType());
        }
    }
}

