/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.base;

import edu.uiowa.physics.pw.pds.PdsColumn;
import edu.uiowa.physics.pw.pds.PdsVolume;
import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsObjFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import pds.label.PDSElement;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PdsObj {
    protected static boolean g_bValidate = true;
    protected String m_sType;
    protected String m_sName;
    protected Map<String, PDSElement> m_elements = new HashMap<String, PDSElement>();
    protected Map<String, PdsChildObj> m_objects = new HashMap<String, PdsChildObj>();

    public static void enableValidation(boolean bCheck) {
        g_bValidate = bCheck;
    }

    public static PdsPtrType ptrType(String sKeyword) {
        if (sKeyword.charAt(0) != '^') {
            return PdsPtrType.NOT_A_PTR;
        }
        if (sKeyword.endsWith("DESCRIPTION") || sKeyword.endsWith("DESC")) {
            return PdsPtrType.DESCRIPTION;
        }
        if (sKeyword.endsWith("STRUCTURE") || sKeyword.endsWith("CATALOG") || sKeyword.endsWith("MAP_PROJECTION")) {
            return PdsPtrType.INCLUDE;
        }
        return PdsPtrType.DATA;
    }

    protected abstract boolean isElementAllowed(String var1);

    protected abstract boolean isObjectAllowed(Class var1);

    protected abstract List<String> getRequiredElements();

    protected abstract List<Class> getRequiredObjs();

    public abstract PdsVolume getVolume();

    public abstract String getLabelBasename();

    public abstract String getLabelRelDir();

    public String getLabelRelPath() {
        if (this.getLabelRelDir() == "") {
            return this.getLabelBasename();
        }
        return this.getLabelRelDir() + "/" + this.getLabelBasename();
    }

    public PdsObj(String sType) throws PDSException {
        if (PdsObjFactory.knowsType(sType)) {
            this.m_sType = sType;
        } else {
            this.pdsExcept("Object type " + sType + "is not known by this package.\n" + "Update PdsObject.g_sObjTypes and add a new object class to change this.");
        }
        this.m_sName = this.m_sType;
    }

    public String toString() {
        return this.m_sType + " " + this.m_sName;
    }

    public String getType() {
        return this.m_sType;
    }

    public void pdsExcept(String msg) throws PDSException {
        throw new PDSException(this.getLabelRelPath() + ":  " + msg);
    }

    public PDSItem parse(PDSLabel label, PDSItem item) throws PDSException {
        PDSElement element = null;
        PDSItem _item = new PDSItem();
        _item.mStart = item.mStart;
        _item.mEnd = item.mEnd;
        while (_item.isValid()) {
            element = label.getElement(_item);
            if (element.mType == 3 || element.mType == 4) {
                _item = label.nextItem(_item);
                continue;
            }
            if (element.mKeyword.equals("OBJECT")) {
                _item = this.parseSubObject(label, _item);
                continue;
            }
            _item = label.nextItem(_item);
            if (this.addElement(element)) continue;
        }
        if (g_bValidate) {
            this.validate();
        }
        return _item;
    }

    public boolean addElement(PDSElement el) throws PDSException {
        PdsPtrType pType;
        String sKey = el.mKeyword;
        if (sKey.charAt(0) == '^' && (pType = PdsObj.ptrType(sKey)) != PdsPtrType.DESCRIPTION) {
            this.pdsExcept("Pointers of type " + pType + " are not permitted in" + this.m_sType + " objects.");
        }
        if (sKey.equals("END_OBJECT")) {
            return false;
        }
        if (!this.isElementAllowed(sKey)) {
            this.pdsExcept("Elements of type " + el.mKeyword + " not permitted in " + this.m_sType + " objects.");
        }
        this.m_elements.put(el.mKeyword, el);
        if (sKey.equals("NAME")) {
            this.m_sName = el.value(0);
        }
        return true;
    }

    public PDSItem parseSubObject(PDSLabel label, PDSItem item) throws PDSException {
        PdsChildObj obj;
        PDSElement element = label.getElement(item);
        String sKey = element.mKeyword;
        if (element.valueSize() != 1) {
            this.pdsExcept("Syntax error in element " + sKey + " = " + element.valueString());
        }
        String sObjInitialName = element.value(0);
        PDSItem secondItem = label.nextItem(item);
        if (!secondItem.isValid()) {
            this.pdsExcept("Incomplete object definition.");
        }
        if (!this.isObjectAllowed((obj = PdsObjFactory.newChildObj(this, sObjInitialName)).getClass())) {
            this.pdsExcept("Objects of type " + obj.getType() + " can not be direct children of a " + this.m_sType + ". (See PdsFile.m_allowedObjects) ");
        }
        PDSItem retItem = obj.parse(label, secondItem);
        if (this.m_objects.containsKey(obj.getName())) {
            if (obj instanceof PdsColumn) {
                Logger.getLogger("PDS Vol Reader").warning(this.getLabelRelPath() + ": Two column " + "objects share the name " + obj.getName() + ", the second instance will be" + " ignored!");
                return retItem;
            }
            PdsChildObj other = this.m_objects.get(obj.getName());
            this.pdsExcept("Can not have two child objects with the same name (" + obj + ")." + "  Parent object is: " + this.getName());
        }
        this.m_objects.put(obj.getName(), obj);
        return retItem;
    }

    public void validate() throws PDSException {
        List<Class> classes = this.getRequiredObjs();
        for (Class baseClass : classes) {
            boolean bHasOne = false;
            for (PdsChildObj obj : this.m_objects.values()) {
                if (!baseClass.isInstance(obj)) continue;
                bHasOne = true;
                break;
            }
            if (bHasOne) continue;
            this.pdsExcept("A " + this.getClass() + " must have at least one child of type " + baseClass);
        }
        for (String sKey : this.getRequiredElements()) {
            if (this.m_elements.containsKey(sKey)) continue;
            this.pdsExcept(this.m_sType + " missing required keyword " + sKey);
        }
    }

    protected void setName(String sName) {
        this.m_sName = sName;
    }

    public String getName() {
        return this.m_sName;
    }

    public PdsChildObj sub(String sName) throws PDSException {
        PdsChildObj obj = this.m_objects.get(sName);
        if (obj == null) {
            this.pdsExcept("Sub object " + sName + " not found in " + this.m_sType + " " + this.m_sName);
        }
        return obj;
    }

    public String[] val(String sName) throws PDSException {
        PDSElement el = this.m_elements.get(sName);
        if (el == null) {
            this.pdsExcept("Required keyword " + sName + " not found in " + this.m_sType + " " + this.m_sName);
        }
        if (el.valueSize() < 1) {
            this.pdsExcept("Keyword " + sName + " in " + this.m_sType + " " + this.m_sName + " has no value!");
        }
        String[] ary = new String[el.valueSize()];
        for (int i = 0; i < el.valueSize(); ++i) {
            ary[i] = el.value(i);
        }
        return ary;
    }

    public String singleVal(String sName) throws PDSException {
        String[] ary = this.val(sName);
        if (ary.length > 1) {
            this.pdsExcept("Keyword " + sName + " in " + this.m_sType + " " + this.m_sName + " has more than one value");
        }
        return ary[0];
    }

    public int positiveSingleVal(String sName) throws PDSException {
        int nRet = Integer.parseInt(this.singleVal(sName));
        if (nRet <= 0) {
            this.pdsExcept("Value " + sName + " in " + this.m_sType + " " + this.m_sName + " is not a positve integer" + " greater than zero.");
        }
        return nRet;
    }

    public int intSingleVal(String sName) throws PDSException {
        return Integer.parseInt(this.singleVal(sName));
    }

    public float floatSingleVal(String sName) throws PDSException {
        return Float.parseFloat(this.singleVal(sName));
    }

    public boolean hasKeyword(String sName) {
        return sName != null && this.m_elements.containsKey(sName);
    }

    public boolean hasObject(String sName) {
        return sName != null && this.m_objects.containsKey(sName);
    }

    public Set<String> childNameSet() {
        return this.m_objects.keySet();
    }

    public Collection<PdsChildObj> objectValues() {
        return this.m_objects.values();
    }

    public Set<String> elementNameSet() {
        return this.m_elements.keySet();
    }

    public static class PdsPtrType {
        private final String m_sType;
        public static final PdsPtrType DATA = new PdsPtrType("DATA");
        public static final PdsPtrType INCLUDE = new PdsPtrType("INCLUDE");
        public static final PdsPtrType DESCRIPTION = new PdsPtrType("DESCRIPTION");
        public static final PdsPtrType NOT_A_PTR = new PdsPtrType("NOT_A_PTR");

        private PdsPtrType(String sType) {
            this.m_sType = sType;
        }

        public String toString() {
            return this.m_sType;
        }
    }
}

