/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds.base;

import edu.uiowa.physics.pw.pds.base.PdsDataObj;
import edu.uiowa.physics.pw.pds.base.PdsRangeException;
import edu.uiowa.physics.pw.pds.base.TwoNum;
import edu.uiowa.physics.pw.pds.conv.PdsGetterMaker;
import edu.uiowa.physics.pw.pds.conv.PdsValGetter;
import edu.uiowa.physics.pw.pds.conv.VAL_TYPE;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import pds.label.PDSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PdsNumericObj
extends PdsDataObj {
    protected String m_sDataType = null;
    private PdsValGetter m_getInt = null;
    private PdsValGetter m_getLong = null;
    private PdsValGetter m_getBigInt = null;
    private PdsValGetter m_getFloat = null;
    private PdsValGetter m_getDouble = null;
    private PdsValGetter m_getBigDec = null;
    private PdsValGetter m_getCompF = null;
    private PdsValGetter m_getCompD = null;
    private PdsValGetter m_getCompBD = null;

    public PdsNumericObj(String sType, PdsDataObj parent) throws PDSException {
        super(sType, parent);
    }

    public String getDataType() {
        return this.m_sDataType;
    }

    public TwoNum<BigDecimal> cplxBigDecVal() throws IOException, PdsRangeException, PDSException {
        if (this.m_getCompBD == null) {
            this.m_getCompBD = PdsGetterMaker.mk(this.getDataType(), this.getItemSize(), VAL_TYPE.COMP_BIG_DEC);
        }
        return (TwoNum)this.m_getCompBD.get(this.m_file.getBytes(this.readPoint(), this.getItemSize()));
    }

    public TwoNum<Double> cplxDoubleVal() throws IOException, PdsRangeException, PDSException {
        if (this.m_getCompD == null) {
            this.m_getCompD = PdsGetterMaker.mk(this.getDataType(), this.getItemSize(), VAL_TYPE.COMP_DOUBLE);
        }
        return (TwoNum)this.m_getCompD.get(this.m_file.getBytes(this.readPoint(), this.getItemSize()));
    }

    public TwoNum<Float> cplxFloatVal() throws IOException, PdsRangeException, PDSException {
        if (this.m_getCompF == null) {
            this.m_getCompF = PdsGetterMaker.mk(this.getDataType(), this.getItemSize(), VAL_TYPE.COMP_FLOAT);
        }
        return (TwoNum)this.m_getCompF.get(this.m_file.getBytes(this.readPoint(), this.getItemSize()));
    }

    public BigDecimal bigDecVal() throws PdsRangeException, IOException, PDSException {
        if (this.m_getBigDec == null) {
            this.m_getBigDec = PdsGetterMaker.mk(this.getDataType(), this.getItemSize(), VAL_TYPE.BIG_DEC);
        }
        return (BigDecimal)this.m_getBigDec.get(this.m_file.getBytes(this.readPoint(), this.getItemSize()));
    }

    public double doubleVal() throws PdsRangeException, IOException, PDSException {
        if (this.m_getDouble == null) {
            this.m_getDouble = PdsGetterMaker.mk(this.getDataType(), this.getItemSize(), VAL_TYPE.DOUBLE);
        }
        Double d = (Double)this.m_getDouble.get(this.m_file.getBytes(this.readPoint(), this.getItemSize()));
        return d;
    }

    public float floatVal() throws PdsRangeException, IOException, PDSException {
        if (this.m_getFloat == null) {
            this.m_getFloat = PdsGetterMaker.mk(this.getDataType(), this.getItemSize(), VAL_TYPE.FLOAT);
        }
        Float f = (Float)this.m_getFloat.get(this.m_file.getBytes(this.readPoint(), this.getItemSize()));
        return f.floatValue();
    }

    public BigInteger bigIntVal() throws PdsRangeException, IOException, PDSException {
        if (this.m_getBigInt == null) {
            this.m_getBigInt = PdsGetterMaker.mk(this.getDataType(), this.getItemSize(), VAL_TYPE.BIG_INT);
        }
        this.m_getBigInt.get(this.m_file.getBytes(this.readPoint(), this.m_nItemSize));
        return (BigInteger)this.m_getBigInt.get(this.m_file.getBytes(this.readPoint(), this.getItemSize()));
    }

    public long longVal() throws PdsRangeException, IOException, PDSException {
        if (this.m_getLong == null) {
            this.m_getLong = PdsGetterMaker.mk(this.getDataType(), this.getItemSize(), VAL_TYPE.LONG);
        }
        Long l = (Long)this.m_getLong.get(this.m_file.getBytes(this.readPoint(), this.getItemSize()));
        return l;
    }

    public int intVal() throws PdsRangeException, IOException, PDSException {
        if (this.m_getInt == null) {
            this.m_getInt = PdsGetterMaker.mk(this.getDataType(), this.getItemSize(), VAL_TYPE.INT);
        }
        Integer n = (Integer)this.m_getInt.get(this.m_file.getBytes(this.readPoint(), this.getItemSize()));
        return n;
    }
}

