/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds;

import edu.uiowa.physics.pw.pds.PdsFile;
import edu.uiowa.physics.pw.pds.PdsVolume;
import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.das2.util.monitor.ProgressMonitor;
import pds.label.PDSElement;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsProduct
extends PdsChildObj {
    public static List<String> g_reqElements = new ArrayList<String>();
    public static List<Class> g_reqObjects = new ArrayList<Class>();
    private static List<String> m_fileOnlyElements = new ArrayList<String>();
    protected String m_sLblRelDir = null;
    protected String m_sLblBasename = null;
    protected Map<String, PDSElement> m_elements = new HashMap<String, PDSElement>();

    @Override
    protected boolean isElementAllowed(String sElementName) {
        return true;
    }

    @Override
    protected boolean isObjectAllowed(Class childClass) {
        return childClass == PdsFile.class;
    }

    @Override
    protected List<String> getRequiredElements() {
        return g_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return g_reqObjects;
    }

    @Override
    public String getLabelBasename() {
        return this.m_sLblBasename;
    }

    @Override
    public String getLabelRelDir() {
        return this.m_sLblRelDir;
    }

    public PdsProduct(PdsVolume parent, String sRelPath, ProgressMonitor prog) throws FileNotFoundException, PDSException, IOException {
        super("product", parent);
        if (!(parent instanceof PdsVolume)) {
            throw new PDSException("The parent of a PdsProduct object must be a type of VOLUME not a " + parent.getType());
        }
        String sLocalPath = this.getVolume().localFileName(sRelPath, prog);
        File fnTmp = new File(sRelPath);
        this.m_sLblRelDir = fnTmp.getParent();
        this.m_sLblRelDir = this.m_sLblRelDir == null ? "" : this.m_sLblRelDir.replaceAll("\\\\", "/");
        this.m_sLblBasename = fnTmp.getName();
        PDSLabel label = new PDSLabel();
        PDSElement element = null;
        label.parse(sLocalPath);
        PDSItem item = label.findObject("VOLUME");
        if (item != null && item.isValid()) {
            this.pdsExcept("contains a VOLUME object");
        }
        if (!(item = label.findItem("PDS_VERSION_ID")).isValid()) {
            this.pdsExcept("doesn't contain PDS_VERSION_ID, is this really a label?");
        }
        this.expandStructure(label);
        PdsFile curFile = null;
        String sKey = null;
        boolean bImplicit = false;
        while (item.isValid()) {
            element = label.getElement(item);
            if (element.mType == 4 || element.mType == 3) {
                item = label.nextItem(item);
                continue;
            }
            sKey = element.mKeyword;
            if (sKey.equals("OBJECT") || m_fileOnlyElements.contains(sKey) || PdsObj.ptrType(sKey) == PdsObj.PdsPtrType.DATA) {
                if (sKey.equals("OBJECT") && element.valueString().endsWith("FILE")) {
                    curFile = new PdsFile(this);
                    item = curFile.parse(label, item);
                    this.m_objects.put(curFile.getName(), curFile);
                    continue;
                }
                if (curFile == null) {
                    curFile = new PdsFile(this);
                    curFile.parseSetup();
                    bImplicit = true;
                }
                PdsFile.ParseElementOrObject_ret tup = curFile.parseElementOrObject(label, item);
                item = tup.item;
                continue;
            }
            if (sKey.equals("END")) break;
            this.m_elements.put(element.mKeyword, element);
            item = label.nextItem(item);
        }
        if (bImplicit) {
            curFile.parseFinish();
            this.m_objects.put(curFile.getName(), curFile);
        }
    }

    public PdsProduct(PdsVolume volume, String sRelPath) throws FileNotFoundException, PDSException, IOException {
        this(volume, sRelPath, null);
    }

    protected void expandStructure(PDSLabel label) throws FileNotFoundException, PDSException, IOException {
        PDSItem searchItem;
        while ((searchItem = label.findItem("^STRUCTURE")).isValid()) {
            String sLocalStructFilePath;
            String sFile = label.getElement(searchItem).value(0);
            try {
                sLocalStructFilePath = this.getVolume().localFileName(this.m_sLblRelDir + "/" + sFile);
            }
            catch (FileNotFoundException e) {
                sLocalStructFilePath = this.getVolume().localFileName("LABEL/" + sFile);
            }
            PDSLabel structLabel = new PDSLabel();
            structLabel.parse(sLocalStructFilePath);
            label.insertAfter(searchItem, structLabel);
            label.remove(searchItem);
        }
    }

    public PdsFile getFile() throws PDSException {
        if (this.m_objects.size() == 0) {
            this.pdsExcept("does not contain a file object, can't use PdsProduct::getFile.");
        }
        if (this.m_objects.size() > 1) {
            this.pdsExcept("contains multiple file objects, can't use PdsProduct::getFile.");
        }
        PdsFile fTmp = null;
        for (PdsChildObj obj : this.m_objects.values()) {
            if (!(obj instanceof PdsFile)) continue;
            fTmp = (PdsFile)obj;
            break;
        }
        return fTmp;
    }

    public int numFiles() {
        return this.m_objects.size();
    }

    public Set<String> getFileBasenames() {
        return this.m_objects.keySet();
    }

    static {
        m_fileOnlyElements.add("RECORD_TYPE");
        m_fileOnlyElements.add("RECORD_BYTES");
        m_fileOnlyElements.add("FILE_RECORDS");
        m_fileOnlyElements.add("LABEL_RECORDS");
        m_fileOnlyElements.add("ENCODING_TYPE");
        m_fileOnlyElements.add("FILE_NAME");
        m_fileOnlyElements.add("INTERCHANGE_FORMAT");
        m_fileOnlyElements.add("REQUIRED_STORAGE_BYTES");
        m_fileOnlyElements.add("SEQUENCE_NUMBER");
        m_fileOnlyElements.add("UNCOMPRESSED_FILE_NAME");
        g_reqElements.add("PDS_VERSION_ID");
        g_reqObjects.add(PdsFile.class);
    }
}

