/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds;

import edu.uiowa.physics.pw.pds.PdsColumn;
import edu.uiowa.physics.pw.pds.PdsFile;
import edu.uiowa.physics.pw.pds.PdsTable;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.base.PdsObjCreator;
import edu.uiowa.physics.pw.pds.search.PdsRowList;
import edu.uiowa.physics.pw.pds.search.PdsSimpleTblSearcher;
import edu.uiowa.physics.pw.pds.search.PdsTblSearcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsIndexTable
extends PdsTable {
    public static PdsObjCreator creator = new Creator();
    public static List<String> m_allowedElements = new ArrayList<String>();
    public static List<String> m_reqElements = new ArrayList<String>();
    protected boolean m_bCumulative = false;
    protected boolean m_bUsingFileSpec = false;
    protected PdsSimpleTblSearcher m_searcher = null;

    public PdsIndexTable(String sType, PdsFile parent) throws PDSException {
        super(sType, parent);
    }

    @Override
    public boolean isElementAllowed(String sElementName) {
        return m_allowedElements.contains(sElementName);
    }

    @Override
    public boolean isObjectAllowed(Class childClass) {
        return childClass == PdsColumn.class;
    }

    @Override
    protected List<String> getRequiredElements() {
        return m_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return PdsTable.m_reqObjects;
    }

    @Override
    public PDSItem parse(PDSLabel label, PDSItem item) throws PDSException {
        PDSItem ret = super.parse(label, item);
        this.m_bCumulative = this.singleVal("INDEX_TYPE").equals("CUMULATIVE");
        if (this.hasObject("LOGICAL_VOLUME_PATH_NAME")) {
            throw new UnsupportedOperationException("Logical volumes are not currently supported");
        }
        if (this.hasObject("FILE_SPECIFICATION_NAME")) {
            this.m_bUsingFileSpec = true;
        } else if (!this.hasObject("PATH_NAME") || !this.hasObject("FILE_NAME")) {
            throw new PDSException("Either the column FILE_SPECIFICATION_NAME or thecolumns PATH_NAME and FILE_NAME must be present in an INDEX_TABLE");
        }
        return ret;
    }

    public PdsTblSearcher getSearcher() {
        if (this.m_searcher == null) {
            ArrayList<String> exclude = new ArrayList<String>();
            exclude.add("FILE_SPECIFICATION_NAME");
            exclude.add("PATH_NAME");
            exclude.add("FILE_NAME");
            this.m_searcher = new PdsSimpleTblSearcher(this, exclude);
        }
        return this.m_searcher;
    }

    public List<String> getProducts(PdsRowList rowList) throws PDSException, IOException {
        ArrayList<String> relPaths = new ArrayList<String>();
        PdsColumn col_1 = null;
        PdsColumn col_2 = null;
        if (this.m_bUsingFileSpec) {
            col_1 = (PdsColumn)this.sub("FILE_SPECIFICATION_NAME");
        } else {
            col_1 = (PdsColumn)this.sub("PATH_NAME");
            col_2 = (PdsColumn)this.sub("FILE_NAME");
        }
        for (Integer n : rowList) {
            this.setRow(n);
            String sRelPath = null;
            sRelPath = col_1.getString().trim();
            if (sRelPath.length() < 2) continue;
            if (sRelPath.charAt(0) == '/') {
                sRelPath = sRelPath.substring(1);
            }
            if (!this.m_bUsingFileSpec) {
                sRelPath = sRelPath.charAt(sRelPath.length() - 1) != '/' ? sRelPath + "/" + col_2.getString().trim() : sRelPath + col_2.getString().trim();
            }
            relPaths.add(sRelPath);
        }
        return relPaths;
    }

    public boolean getCumulative() {
        return this.m_bCumulative;
    }

    static {
        m_reqElements.addAll(PdsTable.m_reqElements);
        m_reqElements.add("INDEX_TYPE");
        m_allowedElements.addAll(m_reqElements);
        m_allowedElements.add("NAME");
        m_allowedElements.add("DESCRIPTION");
        m_allowedElements.add("INDEXED_FILE_NAME");
        m_allowedElements.add("UNKNOWN_CONSTANT");
        m_allowedElements.add("NOT_APPLICABLE_CONSTANT");
    }

    private static class Creator
    implements PdsObjCreator {
        private Creator() {
        }

        public PdsObj create(PdsObj parent) throws PDSException {
            if (parent instanceof PdsFile) {
                return new PdsIndexTable("INDEX_TABLE", (PdsFile)parent);
            }
            throw new PDSException("INDEX_TABLE expects to be a child of a FILE not a " + parent.getType());
        }
    }
}

