/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds;

import edu.uiowa.physics.pw.pds.PdsAlias;
import edu.uiowa.physics.pw.pds.PdsSpreadsheet;
import edu.uiowa.physics.pw.pds.base.PdsDataObj;
import edu.uiowa.physics.pw.pds.base.PdsNumericObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.base.PdsObjCreator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsField
extends PdsNumericObj {
    public static PdsObjCreator creator = new Creator();
    public static List<String> g_allowedElements = new ArrayList<String>();
    public static List<String> g_reqElements = new ArrayList<String>();
    public static List<Class> g_allowedObjects = new ArrayList<Class>();
    public static List<Class> g_reqObjects = new ArrayList<Class>();
    protected int m_nMaxItemLen = 0;
    protected boolean m_bHasCharData = false;
    protected ItemOffsets[] m_itemPosAry = null;

    public PdsField(String sType, PdsDataObj parent) throws PDSException {
        super(sType, parent);
        if (!(parent instanceof PdsSpreadsheet)) {
            throw new PDSException("FIELDs expect to be children of SPREADSHEETs not " + parent.getType());
        }
    }

    @Override
    protected boolean isElementAllowed(String sElementName) {
        return g_allowedElements.contains(sElementName);
    }

    @Override
    protected boolean isObjectAllowed(Class childClass) {
        return g_allowedObjects.contains(childClass);
    }

    @Override
    protected List<String> getRequiredElements() {
        return g_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return g_reqObjects;
    }

    @Override
    public PDSItem parse(PDSLabel label, PDSItem item) throws PDSException {
        PDSItem ret = super.parse(label, item);
        this.m_sDataType = this.singleVal("DATA_TYPE");
        if (this.hasKeyword("ITEMS")) {
            this.m_iMaxIndex = this.positiveSingleVal("ITEMS") - 1;
            if (!this.hasKeyword("ITEM_BYTES")) {
                this.pdsExcept("FIELD " + this.getName() + " has subitems but keyword ITEM_BYTES is" + " missing.");
            }
            this.m_nMaxItemLen = this.positiveSingleVal("ITEM_BYTES");
        } else {
            this.m_iMaxIndex = 0;
            this.m_nMaxItemLen = this.positiveSingleVal("BYTES");
        }
        if (this.singleVal("DATA_TYPE").equals("CHARACTER")) {
            this.m_nMaxItemLen += 2;
            this.m_bHasCharData = true;
        }
        this.m_itemPosAry = new ItemOffsets[this.m_iMaxIndex + 1];
        for (int i = 0; i <= this.m_iMaxIndex; ++i) {
            this.m_itemPosAry[i] = new ItemOffsets(i, i - 1);
        }
        return ret;
    }

    public boolean isEmpty() {
        ItemOffsets io = this.m_itemPosAry[this.m_iCurIndex];
        if (io.iStart > io.iEnd) {
            return true;
        }
        return this.m_bHasCharData && io.iEnd - io.iStart < 2;
    }

    void setEndOffset(int iInclusiveEndIndex, char cDelim) throws IOException, PDSException {
        int i;
        if (this.m_iMaxIndex < 1) {
            this.m_itemPosAry[0] = new ItemOffsets(0, iInclusiveEndIndex - this.m_nBaseOffset);
            return;
        }
        if (iInclusiveEndIndex < this.m_nBaseOffset + this.m_iMaxIndex + 1) {
            for (int i2 = 0; i2 <= this.m_iMaxIndex; ++i2) {
                this.m_itemPosAry[i2].iStart = i2;
                this.m_itemPosAry[i2].iEnd = i2 - 1;
            }
            return;
        }
        int nBytes = iInclusiveEndIndex - this.m_nBaseOffset + 1;
        String sField = new String(this.m_file.getBytes(this.m_nBaseOffset, nBytes), "US-ASCII");
        char[] cRow = sField.toCharArray();
        boolean bEscaped = false;
        int iItem = 0;
        this.m_itemPosAry[iItem].iStart = 0;
        for (i = 0; i < cRow.length; ++i) {
            if (cRow[i] == '\"') {
                boolean bl = bEscaped = !bEscaped;
            }
            if (bEscaped || cRow[i] != cDelim) continue;
            if (iItem >= this.m_itemPosAry.length - 1) {
                int nTmp = ((PdsSpreadsheet)this.m_parent).getItem() + 1;
                throw new PDSException(this.m_file.getDataRelPath() + ": Too many items in field " + this.getName() + " in row " + nTmp + " of spreadsheet.");
            }
            if (++iItem > 0) {
                this.m_itemPosAry[iItem - 1].iEnd = i - 1;
            }
            this.m_itemPosAry[iItem].iStart = i + 1;
        }
        this.m_itemPosAry[iItem].iEnd = i - 1;
        if (iItem != this.m_itemPosAry.length - 1) {
            int nTmp = ((PdsSpreadsheet)this.m_parent).getItem() + 1;
            throw new PDSException(this.m_file.getDataRelPath() + ": Too few items in field " + this.getName() + " in row " + nTmp + " of spreadsheet.");
        }
    }

    @Override
    protected int readPoint() {
        if (this.m_bHasCharData) {
            return this.m_nBaseOffset + this.m_itemPosAry[this.m_iCurIndex].iStart + 1;
        }
        return this.m_nBaseOffset + this.m_itemPosAry[this.m_iCurIndex].iStart;
    }

    @Override
    public int getItemSize() {
        if (this.m_bHasCharData) {
            return this.m_itemPosAry[this.m_iCurIndex].itemSize() - 2;
        }
        return this.m_itemPosAry[this.m_iCurIndex].itemSize();
    }

    @Override
    public byte[] getBytes() throws IOException, PDSException {
        return this.m_file.getBytes(this.readPoint(), this.getItemSize());
    }

    static {
        g_reqElements.add("NAME");
        g_reqElements.add("DATA_TYPE");
        g_reqElements.add("BYTES");
        g_reqElements.add("FIELD_NUMBER");
        g_allowedElements.addAll(g_reqElements);
        g_allowedElements.add("DESCRIPTION");
        g_allowedElements.add("FORMAT");
        g_allowedElements.add("ITEM_BYTES");
        g_allowedElements.add("ITEMS");
        g_allowedElements.add("UNIT");
        g_allowedElements.add("VALID_MAXIMUM");
        g_allowedElements.add("VALID_MINIMUM");
        g_allowedObjects.add(PdsAlias.class);
    }

    protected class ItemOffsets {
        public int iStart = 0;
        public int iEnd = 0;

        public ItemOffsets(int start, int end) {
            this.iStart = start;
            this.iEnd = end;
        }

        public int itemSize() {
            return this.iEnd - this.iStart + 1;
        }
    }

    private static class Creator
    implements PdsObjCreator {
        private Creator() {
        }

        public PdsObj create(PdsObj parent) throws PDSException {
            if (parent instanceof PdsSpreadsheet) {
                return new PdsField("FIELD", (PdsDataObj)parent);
            }
            throw new PDSException("The parent of a FIELD object must be a type of SPREADSHEET not a " + parent.getType());
        }
    }
}

