/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds;

import edu.uiowa.physics.pw.pds.PdsVolume;
import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.base.PdsObjCreator;
import java.util.ArrayList;
import java.util.List;
import pds.label.PDSElement;
import pds.label.PDSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsDataProducer
extends PdsChildObj {
    public static Creator creator = new Creator();
    public static List<String> g_allowedElements = new ArrayList<String>();
    public static List<String> g_reqElements = new ArrayList<String>();
    public static List<Class> g_allowedObjects = new ArrayList<Class>();
    public static List<Class> g_reqObjects = new ArrayList<Class>();

    protected PdsDataProducer(String sType, PdsObj catalog) throws PDSException {
        super(sType, catalog);
    }

    @Override
    protected boolean isElementAllowed(String sElementName) {
        return g_allowedElements.contains(sElementName);
    }

    @Override
    protected boolean isObjectAllowed(Class childClass) {
        return g_allowedObjects.contains(childClass);
    }

    @Override
    protected List<String> getRequiredElements() {
        return g_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return g_reqObjects;
    }

    @Override
    public boolean addElement(PDSElement el) throws PDSException {
        if (!super.addElement(el)) {
            return false;
        }
        String sKey = el.mKeyword;
        if (sKey.equals("FULL_NAME")) {
            this.m_sName = el.value(0);
        }
        return true;
    }

    static {
        g_reqElements.add("INSTITUTION_NAME");
        g_reqElements.add("FACILITY_NAME");
        g_reqElements.add("FULL_NAME");
        g_reqElements.add("ADDRESS_TEXT");
        g_allowedElements.addAll(g_reqElements);
        g_allowedElements.add("DISCIPLINE_NAME");
        g_allowedElements.add("NODE_NAME");
        g_allowedElements.add("TELEPHONE_NUMBER");
        g_allowedElements.add("ELECTRONIC_MAIL_TYPE");
        g_allowedElements.add("ELECTRONIC_MAIL_ID");
    }

    public static class Creator
    implements PdsObjCreator {
        public PdsObj create(PdsObj parent) throws PDSException {
            if (parent instanceof PdsVolume) {
                return new PdsDataProducer("DATA_PRODUCER", parent);
            }
            throw new PDSException("The parent of a DATA_PRODUCER object must be a type of CATALOG not a " + parent.getType());
        }
    }
}

