/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds;

import edu.uiowa.physics.pw.pds.PdsColumn;
import edu.uiowa.physics.pw.pds.PdsTable;
import edu.uiowa.physics.pw.pds.base.PdsDataObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.base.PdsObjCreator;
import java.util.ArrayList;
import java.util.List;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsContainer
extends PdsDataObj {
    public static PdsObjCreator creator = new Creator();
    public static List<String> g_reqElements = new ArrayList<String>();
    public static List<String> g_allowedElements = new ArrayList<String>();
    public static List<Class> g_allowedObjects = new ArrayList<Class>();

    public PdsContainer(PdsDataObj parent) throws PDSException {
        super("CONTAINER", parent);
        if (!(parent instanceof PdsTable) && !(parent instanceof PdsContainer)) {
            throw new PDSException("CONTAINERSs expect to be children of TABLEs or other CONTAINERs not " + parent.getType());
        }
    }

    @Override
    public void validate() throws PDSException {
        super.validate();
        if (this.m_objects.size() < 1) {
            this.pdsExcept("no child objects defined for the CONTAINER.");
        }
    }

    @Override
    public PDSItem parse(PDSLabel label, PDSItem item) throws PDSException {
        PDSItem ret = super.parse(label, item);
        this.m_nPrefixSize = this.positiveSingleVal("START_BYTE") - 1;
        this.m_nStepSize = this.m_nItemSize = this.positiveSingleVal("BYTES") - 1;
        this.m_iMaxIndex = this.positiveSingleVal("REPETITIONS") - 1;
        return ret;
    }

    @Override
    protected boolean isElementAllowed(String sElementName) {
        return g_reqElements.contains(sElementName);
    }

    @Override
    protected boolean isObjectAllowed(Class childClass) {
        return g_allowedObjects.contains(childClass);
    }

    @Override
    protected List<String> getRequiredElements() {
        return g_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return new ArrayList<Class>();
    }

    static {
        g_reqElements.add("NAME");
        g_reqElements.add("START_BYTE");
        g_reqElements.add("BYTES");
        g_reqElements.add("REPETITIONS");
        g_reqElements.add("DESCRIPTION");
        g_allowedObjects.add(PdsColumn.class);
        g_allowedObjects.add(PdsContainer.class);
    }

    private static class Creator
    implements PdsObjCreator {
        private Creator() {
        }

        public PdsObj create(PdsObj parent) throws PDSException {
            if (parent instanceof PdsContainer || parent instanceof PdsTable) {
                return new PdsContainer((PdsDataObj)parent);
            }
            throw new PDSException("The parent of a CONTAINER object must be type of TABLE or another CONTAINER not a " + parent.getType());
        }
    }
}

