/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.pds;

import edu.uiowa.physics.pw.pds.PdsColumn;
import edu.uiowa.physics.pw.pds.base.PdsChildObj;
import edu.uiowa.physics.pw.pds.base.PdsObj;
import edu.uiowa.physics.pw.pds.base.PdsObjCreator;
import edu.uiowa.physics.pw.pds.base.PdsRangeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdsBitColumn
extends PdsChildObj {
    public static PdsObjCreator creator = new Creator();
    public static List<String> g_allowedElements = new ArrayList<String>();
    public static List<String> g_reqElements = new ArrayList<String>();
    private static int[] m_nMasks = new int[32];
    protected int m_nItemBits;
    protected int m_nPrefixBits;
    protected int m_nOffsetBits;
    protected int m_iCurItem = 0;
    protected int m_iMaxIndex = 0;
    private PdsColumn m_column = null;

    public PdsBitColumn(String sType, PdsColumn parent) throws PDSException {
        super(sType, parent);
        this.m_column = parent;
    }

    @Override
    protected boolean isElementAllowed(String sElementName) {
        return g_allowedElements.contains(sElementName);
    }

    @Override
    protected boolean isObjectAllowed(Class childClass) {
        return false;
    }

    @Override
    protected List<String> getRequiredElements() {
        return g_reqElements;
    }

    @Override
    protected List<Class> getRequiredObjs() {
        return new ArrayList<Class>();
    }

    @Override
    public PDSItem parse(PDSLabel label, PDSItem item) throws PDSException {
        PDSItem ret = super.parse(label, item);
        this.m_nPrefixBits = this.positiveSingleVal("START_BIT") - 1;
        if (this.hasKeyword("ITEMS")) {
            this.m_iMaxIndex = this.positiveSingleVal("ITEMS") - 1;
            this.m_nItemBits = this.positiveSingleVal("ITEM_BITS");
            this.m_nOffsetBits = this.hasKeyword("ITEM_OFFSET") ? this.positiveSingleVal("ITEM_OFFSET") : this.m_nItemBits;
        } else {
            this.m_nItemBits = this.positiveSingleVal("BITS");
        }
        return ret;
    }

    public int size() {
        return this.m_iMaxIndex + 1;
    }

    public int getItemBitSize() {
        return this.m_nItemBits;
    }

    public void item(int iItem) throws ArrayIndexOutOfBoundsException {
        if (iItem > this.m_iMaxIndex || iItem < 0) {
            throw new ArrayIndexOutOfBoundsException("Index " + iItem + "does not exist in " + "object " + this.m_sName + ".  Valid range is 0 to " + this.m_iMaxIndex + ".");
        }
        this.m_iCurItem = iItem;
    }

    public int intVal() throws IOException, PDSException, PdsRangeException {
        int n = this.m_column.intVal();
        int nShift = this.m_column.getItemSize() * 8;
        if ((nShift -= (this.m_iCurItem + 1) * this.m_nOffsetBits + this.m_nPrefixBits) > 0) {
            n >>= nShift;
        }
        return n &= m_nMasks[this.m_nItemBits - 1];
    }

    public String getString() throws IOException, PDSException, PdsRangeException {
        String sRet = Integer.toBinaryString(this.intVal());
        assert (sRet.length() <= this.m_nItemBits);
        for (int i = 0; i < this.m_nItemBits - sRet.length(); ++i) {
            sRet = "0" + sRet;
        }
        return sRet;
    }

    static {
        g_reqElements.add("NAME");
        g_reqElements.add("BIT_DATA_TYPE");
        g_reqElements.add("START_BIT");
        g_reqElements.add("DESCRIPTION");
        g_allowedElements.addAll(g_reqElements);
        g_allowedElements.add("BITS");
        g_allowedElements.add("ITEM_BITS");
        g_allowedElements.add("BIT_MASK");
        g_allowedElements.add("FORMAT");
        g_allowedElements.add("INVALID_CONSTANT");
        g_allowedElements.add("ITEMS");
        g_allowedElements.add("MINIMUM");
        g_allowedElements.add("MAXIMUM");
        g_allowedElements.add("MISSING_CONSTANT");
        g_allowedElements.add("OFFSET");
        g_allowedElements.add("SCALING_FACTOR");
        g_allowedElements.add("UNIT");
        PdsBitColumn.m_nMasks[0] = 1;
        int nAccum = 1;
        for (int i = 1; i < 31; ++i) {
            PdsBitColumn.m_nMasks[i] = (nAccum *= 2) + m_nMasks[i - 1];
        }
        PdsBitColumn.m_nMasks[31] = -1;
    }

    private static class Creator
    implements PdsObjCreator {
        private Creator() {
        }

        public PdsObj create(PdsObj parent) throws PDSException {
            if (parent instanceof PdsColumn) {
                return new PdsBitColumn("BIT_COLUMN", (PdsColumn)parent);
            }
            throw new PDSException("The parent of a BIT_COLUMN object must be a type of COLUMN not a " + parent.getType());
        }
    }
}

