/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.Spacecraft;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import org.das2.DasException;
import org.das2.components.DasProgressPanel;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.fsm.FileStorageModelNew;
import org.das2.graph.GraphUtil;
import org.das2.util.DasExceptionHandler;
import org.das2.util.TimeParser;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;

public class MagDataSetDescriptor
extends DataSetDescriptor {
    FileStorageModelNew fsm;
    boolean fce;
    boolean availability;

    MagDataSetDescriptor(Spacecraft sc, boolean fce) throws FileSystem.FileSystemOfflineException {
        this(sc, fce, false);
    }

    MagDataSetDescriptor(Spacecraft sc, boolean fce, boolean availability) throws FileSystem.FileSystemOfflineException {
        this.fce = fce;
        this.availability = availability;
        this.setSpacecraft(sc);
    }

    private FileStorageModelNew createFileStorageModel(String sc) throws FileSystem.FileSystemOfflineException {
        FileSystem fs;
        try {
            fs = FileSystem.create(new URL("http://www-pw.physics.uiowa.edu/~jbf/voyager/mag/vg" + sc + "/"));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        FileStorageModelNew fsm = FileStorageModelNew.create(fs, "%Y-%m-%d.bmag");
        return fsm;
    }

    private void setSpacecraft(Spacecraft sc) {
        block4: {
            try {
                if (sc == Spacecraft.voyager1) {
                    this.fsm = this.createFileStorageModel("1");
                    break block4;
                }
                if (sc == Spacecraft.voyager2) {
                    this.fsm = this.createFileStorageModel("2");
                    break block4;
                }
                throw new IllegalArgumentException("not supported spacecraft:" + sc);
            }
            catch (FileSystem.FileSystemOfflineException e) {
                DasExceptionHandler.handle(e);
            }
        }
    }

    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        DatumRange range = new DatumRange(start, end);
        try {
            Object result = null;
            if (this.availability) {
                String[] names = this.fsm.getNamesFor(range);
                VectorDataSetBuilder builder = new VectorDataSetBuilder(Units.us2000, Units.seconds);
                for (int i = 0; i < names.length; ++i) {
                    DatumRange r = this.fsm.getRangeFor(names[i]);
                    builder.insertY(r.min(), r.width());
                }
                builder.setProperty("cacheTag", FileStorageModelNew.getCacheTagFor(this.fsm, range, names));
                return builder.toVectorDataSet();
            }
            File[] files = this.fsm.getFilesFor(range, monitor);
            if (files.length == 0) {
                throw new NoDataInIntervalException("no files cover: " + new DatumRange(start, end));
            }
            TimeParser tparser = TimeParser.create("%Y-%m-%dT%H:%M:%S.%{milli}Z");
            TimeLocationUnits xunits = Units.us2000;
            Units yunits = this.fce ? Units.hertz : Units.dimensionless;
            VectorDataSetBuilder builder = new VectorDataSetBuilder(xunits, yunits);
            for (int i = 0; i < files.length; ++i) {
                BufferedReader reader = new BufferedReader(new FileReader(files[i]));
                String line = reader.readLine();
                while (line != null) {
                    double y = Double.parseDouble(line.substring(25));
                    if (y > 9999.0) {
                        y = yunits.getFillDouble();
                    } else if (this.fce) {
                        y *= 28.0;
                    }
                    builder.insertY(tparser.parse(line.substring(0, 25)).getTime(xunits), y);
                    line = reader.readLine();
                }
            }
            builder.setProperty("cacheTag", FileStorageModelNew.getCacheTagFor(this.fsm, range, files));
            return builder.toVectorDataSet();
        }
        catch (ParseException e) {
            throw new DasException(e.getMessage());
        }
        catch (IOException e) {
            throw new DasException(e.getMessage());
        }
    }

    public Units getXUnits() {
        return Units.us2000;
    }

    public static DataSetDescriptor newDataSetDescriptor(Map props) {
        Spacecraft sc = Spacecraft.getByInt(Integer.parseInt((String)props.get("voyager")));
        boolean fce = Boolean.parseBoolean((String)props.get("fce"));
        boolean availability = props.get("availability") == null ? false : Boolean.parseBoolean((String)props.get("availability"));
        try {
            return new MagDataSetDescriptor(sc, fce, availability);
        }
        catch (FileSystem.FileSystemOfflineException ex) {
            throw new RuntimeException(ex);
        }
    }

    public FileStorageModelNew getFileStorageModel() {
        return this.fsm;
    }

    public static void main(String[] args) throws DasException, FileSystem.FileSystemOfflineException {
        MagDataSetDescriptor dsd = new MagDataSetDescriptor(Spacecraft.voyager2, true);
        DatumRange range = DatumRangeUtil.parseTimeRangeValid("1979-07-28 through 1979-07-29");
        DataSet ds = dsd.getDataSet(range.min(), range.max(), null, DasProgressPanel.createFramed("help!!!"));
        GraphUtil.visualize(ds);
    }
}

