/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.VoyagerHighRate;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.das2.DasApplication;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.util.DasExceptionHandler;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;

public class LauncherApplet
extends JApplet {
    boolean waiting = true;
    JFrame appFrame;
    VoyagerHighRate app;
    File localRootFile;
    File localFile;
    URL localRootURL;

    public void setLocalFileWeb(final String name) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    LauncherApplet.this.setLocalFileWebImmediately(name);
                }
                catch (FileSystem.FileSystemOfflineException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    protected void setLocalFileWebImmediately(String name) throws FileSystem.FileSystemOfflineException {
        if (this.app == null) {
            this.launch();
        } else {
            this.appFrame.setVisible(true);
        }
        FileSystem fs = FileSystem.create(this.localRootURL);
        File file = null;
        String pngFileName = name;
        pngFileName = pngFileName.replace("BROWSE/", "DATA/");
        pngFileName = pngFileName.substring(0, pngFileName.length() - 4) + ".DAT";
        FileObject fo = fs.getFileObject(pngFileName);
        try {
            ProgressMonitor mon = DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(this.app.getPlot(), "loading file", "loading data file over http");
            file = fo.getFile(mon);
        }
        catch (FileNotFoundException ex) {
            DasExceptionHandler.handle(ex);
        }
        catch (IOException ex) {
            DasExceptionHandler.handle(ex);
        }
        this.app.setLocalFile(new File[]{file});
        this.localFile = file;
        this.waiting = false;
        this.repaint();
    }

    public void setLocalFile(final String pngFileName) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LauncherApplet.this.setLocalFileImmediately(pngFileName);
            }
        });
    }

    private void setLocalFileImmediately(String pngFileName) {
        if (this.localRootFile == null) {
            throw new RuntimeException("docbase is not a file://");
        }
        pngFileName = pngFileName.replace("BROWSE/", "DATA/");
        File dataFile = new File(this.localRootFile, pngFileName.substring(0, pngFileName.length() - 4) + ".DAT");
        if (this.app == null) {
            this.launch();
        } else {
            this.appFrame.setVisible(true);
        }
        this.app.setLocalFile(new File[]{dataFile});
        this.localFile = dataFile;
        this.waiting = false;
        this.repaint();
    }

    private File getDirectoryFromDocBaseURL(URL docBase, String localRoot) {
        String surl = docBase.toString();
        String string = surl.substring("file:".length());
        int idx = string.indexOf(":");
        if (idx != -1) {
            string = string.substring(idx - 1);
        }
        if (string.endsWith("HTM")) {
            idx = string.lastIndexOf("/");
            string = string.substring(0, idx);
        }
        File docBaseFile = new File(string);
        try {
            File result = new File(docBaseFile, localRoot);
            result = result.getCanonicalFile();
            return result;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void launch() {
        this.appFrame = new JFrame();
        this.app = new VoyagerHighRate(true, this.appFrame);
        this.app.renderer.getZAxis().setDatumRange(new DatumRange(1.0E-5, 0.1, Units.dimensionless));
        this.appFrame.pack();
        this.appFrame.setVisible(true);
        this.appFrame.setDefaultCloseOperation(1);
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.DARK_GRAY);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.white);
        if (this.waiting) {
            // empty if block
        }
    }

    public void destroy() {
        super.destroy();
        if (this.appFrame != null) {
            this.appFrame.dispose();
        }
    }

    public void init() {
        super.init();
        DasApplication.getDefaultApplication().setApplet(true);
        DasApplication.getDefaultApplication().setHeadless(false);
        String localRoot = this.getParameter("root");
        if (localRoot == null) {
            localRoot = "../..";
        }
        URL docBase = this.getDocumentBase();
        if (localRoot.startsWith("/") || localRoot.charAt(1) == ':') {
            this.localRootFile = new File(localRoot);
        } else {
            this.localRootFile = docBase.getProtocol().equals("file") ? this.getDirectoryFromDocBaseURL(docBase, localRoot) : null;
            try {
                this.localRootURL = new URL(docBase, localRoot);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private JFrame debuggerHelper() {
        JFrame f = new JFrame("debuggerHelper");
        Box vertPanel = new Box(1);
        vertPanel.add(new JButton(new AbstractAction("setTimePart"){

            public void actionPerformed(ActionEvent e) {
                LauncherApplet.this.setLocalFileWeb("BROWSE/P6/V20721/C1178858.PNG");
            }
        }));
        vertPanel.add(new JButton(new AbstractAction("setTimePart2"){

            public void actionPerformed(ActionEvent e) {
                LauncherApplet.this.setLocalFileWeb("BROWSE/P6/V20721/C1189328.PNG");
            }
        }));
        f.getContentPane().add(vertPanel);
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation(1);
        return f;
    }

    public static void main(String[] args) {
        LauncherApplet applet = new LauncherApplet();
        applet.setStub(new MyAppletStub());
        JFrame frame = new JFrame("Applet");
        frame.setContentPane(applet);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        ((Applet)applet).init();
        applet.start();
    }

    static class MyAppletStub
    implements AppletStub {
        HashMap params = new HashMap();

        MyAppletStub() {
            this.params.put("root", "../..");
        }

        public void appletResize(int param, int param1) {
        }

        public AppletContext getAppletContext() {
            return null;
        }

        public URL getCodeBase() {
            return null;
        }

        public URL getDocumentBase() {
            try {
                return new URL("http://www-pw.physics.uiowa.edu/~jbf/VGPW_2007/EXTRAS/HTML/");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public String getParameter(String str) {
            return (String)this.params.get(str);
        }

        public boolean isActive() {
            return true;
        }
    }
}

