/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.DensityFileDataSetDescriptor;
import java.util.HashMap;
import org.das2.DasException;
import org.das2.dataset.CacheTag;
import org.das2.dataset.ClippedVectorDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;

public class IndexedDensityFileDataSetDescriptor
extends DataSetDescriptor {
    String voyagerNum;
    DensityFileDataSetDescriptor.PlaneType planeType;
    VectorDataSet index;

    public IndexedDensityFileDataSetDescriptor(String voyagerNum, DensityFileDataSetDescriptor.PlaneType planeType, VectorDataSet index) {
        this.planeType = planeType;
        this.index = index;
        this.voyagerNum = voyagerNum;
    }

    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        try {
            String defaultType;
            Datum t = start;
            String currentType = defaultType = "p";
            HashMap<String, VectorDataSet> datasets = new HashMap<String, VectorDataSet>();
            if (this.index == null) {
                DensityFileDataSetDescriptor.SourceType stype = (DensityFileDataSetDescriptor.SourceType)DensityFileDataSetDescriptor.sourceTypeInstances.get(currentType);
                DensityFileDataSetDescriptor dsd = new DensityFileDataSetDescriptor(this.voyagerNum, stype, this.planeType);
                VectorDataSet ds = (VectorDataSet)dsd.getDataSet(start, end, resolution, ProgressMonitor.NULL);
                datasets.put(currentType, ds);
                return ds;
            }
            EnumerationUnits units = (EnumerationUnits)this.index.getYUnits();
            VectorDataSet widthsDs = (VectorDataSet)this.index.getPlanarView("width");
            VectorDataSetBuilder builder = new VectorDataSetBuilder(Units.us2000, Units.hertz);
            while (t.lt(end)) {
                DatumRange current;
                int i = DataSetUtil.getPreviousColumn(this.index, t);
                if (i < this.index.getXLength() - 1 && this.index.getXTagDatum(i + 1).equals(t)) {
                    ++i;
                }
                Datum w = widthsDs.getDatum(i);
                DatumRange test = new DatumRange(this.index.getXTagDatum(i), this.index.getXTagDatum(i).add(w));
                if (test.contains(t)) {
                    currentType = (String)units.getObject(this.index.getDatum(i));
                    current = test;
                } else {
                    currentType = defaultType;
                    Datum endt = test.min().gt(t) ? test.min() : (i < this.index.getXLength() - 1 ? this.index.getXTagDatum(i + 1) : end);
                    current = new DatumRange(t, endt);
                }
                VectorDataSet ds = (VectorDataSet)datasets.get(currentType);
                if (ds == null) {
                    DensityFileDataSetDescriptor.SourceType stype = (DensityFileDataSetDescriptor.SourceType)DensityFileDataSetDescriptor.sourceTypeInstances.get(currentType);
                    DensityFileDataSetDescriptor dsd = new DensityFileDataSetDescriptor(this.voyagerNum, stype, this.planeType);
                    ds = (VectorDataSet)dsd.getDataSet(start, end, null, ProgressMonitor.NULL);
                    datasets.put(currentType, ds);
                }
                if (ds != null) {
                    builder.append(new ClippedVectorDataSet(ds, current));
                }
                t = current.max();
            }
            builder.setProperty("cacheTag", new CacheTag(start, end, null));
            return builder.toVectorDataSet();
        }
        catch (FileSystem.FileSystemOfflineException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Units getXUnits() {
        return Units.us2000;
    }
}

