/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.IndexTypeDialog;
import java.awt.Color;
import java.awt.Frame;
import java.util.HashMap;
import javax.swing.JFrame;
import org.das2.components.DataPointRecorder;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.BoxSelectorMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.EventsRenderer;

public class IndexTool {
    EventsRenderer renderer;
    DataPointRecorder recorder;
    EnumerationUnits typeUnits = new EnumerationUnits("digitizeType");
    final HashMap typeColorMap = new HashMap();
    IndexTypeDialog typePopup;
    BoxSelectionListener listener;
    DataSetUpdateListener dataListener;

    DatumRange descretize(DatumRange dr, Datum base, Datum granularity) {
        base = base.convertTo(dr.getUnits());
        Units u = dr.getUnits().getOffsetUnits();
        double min = dr.min().subtract(base).doubleValue(u);
        double max = dr.max().subtract(base).doubleValue(u);
        double dd = granularity.doubleValue(u);
        Datum dmin = base.add(u.createDatum(Math.floor(min / dd) * dd));
        Datum dmax = base.add(u.createDatum(Math.ceil(max / dd) * dd));
        return new DatumRange(dmin, dmax);
    }

    IndexTool(DasPlot p, JFrame appFrame) {
        this.typeColorMap.put(this.typeUnits.createDatum("R"), Color.RED);
        this.typeColorMap.put(this.typeUnits.createDatum("u"), Color.BLUE);
        this.typeColorMap.put(this.typeUnits.createDatum("L"), Color.GREEN);
        this.typeColorMap.put(this.typeUnits.createDatum("p"), Color.ORANGE);
        this.listener = new BoxSelectionListener(){

            public void BoxSelected(BoxSelectionEvent e) {
                DatumRange range = IndexTool.this.descretize(e.getXRange(), Units.us2000.createDatum(0), IndexTool.this.recorder.getXTagWidth());
                IndexTool.this.typePopup.setVisible(true);
                int r = IndexTool.this.typePopup.getReturnStatus();
                IndexTypeDialog cfr_ignored_0 = IndexTool.this.typePopup;
                if (r != 1) {
                    return;
                }
                String type = IndexTool.this.typePopup.getIndexType();
                VectorDataSetBuilder builder = new VectorDataSetBuilder(range.getUnits(), IndexTool.this.typeUnits);
                builder.addPlane("width", Units.seconds);
                builder.insertY(range.min(), IndexTool.this.typeUnits.createDatum(type));
                builder.insertY(range.min(), range.width(), "width");
                IndexTool.this.recorder.appendDataSet(builder.toVectorDataSet());
            }
        };
        this.dataListener = new DataSetUpdateListener(){

            public void dataSetUpdated(DataSetUpdateEvent e) {
                VectorDataSet ds = IndexTool.this.recorder.getDataSet();
                IndexTool.this.renderer.setDataSet(ds);
            }
        };
        DasRow typeRow = new DasRow(null, p.getRow(), 1.0, 1.0, 0.0, 0.0, 0, 5);
        p.getXAxis().setVisible(false);
        DasAxis yAxis = new DasAxis(new DatumRange(0.0, 1.0, Units.dimensionless), 3);
        yAxis.setVisible(false);
        DasPlot ind = new DasPlot(p.getXAxis().createAttachedAxis(), yAxis);
        this.renderer = new EventsRenderer();
        this.renderer.setColorSpecifier(new EventsRenderer.ColorSpecifier(){

            public Color getColor(Datum d) {
                return (Color)IndexTool.this.typeColorMap.get(d);
            }
        });
        this.renderer.setWidthPlaneId("width");
        ind.addRenderer(this.renderer);
        p.getCanvas().add(ind, typeRow, p.getColumn());
        p.getCanvas().revalidate();
        this.recorder = new DataPointRecorder();
        this.recorder.setXTagWidth(Units.milliseconds.createDatum(500));
        this.recorder.addDataSetUpdateListener(this.dataListener);
        BoxSelectorMouseModule mm = new BoxSelectorMouseModule(p, p.getXAxis(), null, this.renderer, new BoxRenderer(p, false), "Index Select");
        mm.addBoxSelectionListener(this.listener);
        p.addMouseModule(mm);
        this.typePopup = new IndexTypeDialog((Frame)appFrame, true);
    }

    DataPointRecorder getRecorder() {
        return this.recorder;
    }
}

