/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.EZVectorDataSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;

public class HighRateReader {
    private ByteBuffer buf;
    private String fileTitle;
    private Datum baseTime;
    private int recordCount;
    private File file;

    public HighRateReader(File f) throws IOException {
        this.openFile(f);
    }

    private void openFile(File f) throws IOException {
        FileChannel fc = new FileInputStream(f).getChannel();
        long fileSize = fc.size();
        this.buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
        this.recordCount = (int)(fileSize / 1024L) - 1;
        byte[] titleBytes = new byte[776];
        this.buf.position(248);
        this.buf.limit(248 + titleBytes.length);
        this.buf.get(titleBytes);
        this.buf.position(0);
        this.buf.limit(this.buf.capacity());
        this.fileTitle = new String(titleBytes);
        int idxNull = this.fileTitle.indexOf(0);
        this.fileTitle = this.fileTitle.substring(0, idxNull);
        this.baseTime = TimeUtil.createValid(this.fileTitle.substring(26));
        this.file = f;
    }

    protected int getLineCounter(int record) {
        return (this.buf.get((record + 1) * 1024 + 22) & 0xFF) << 8 | this.buf.get((record + 1) * 1024 + 23) & 0xFF;
    }

    public int getLineContainingTime(Datum time) {
        int result;
        double msDiff = time.subtract(this.baseTime).doubleValue(Units.milliseconds);
        int line = (int)(msDiff / 60.0) + 1;
        line = Math.max(1, Math.min(line, this.recordCount()));
        for (result = line - 1; result < this.recordCount() && this.getLineCounter(result) < line; ++result) {
        }
        while (result > 1 && this.getLineCounter(result) > line) {
            --result;
        }
        return result;
    }

    public int recordCount() {
        return this.recordCount;
    }

    public VectorDataSet readRecord(int recordNumber) {
        try {
            this.buf.limit(1024 * (recordNumber + 2));
            this.buf.position(1024 * (recordNumber + 1));
            ByteBuffer recBuffer = this.buf.slice();
            this.buf.position(0);
            this.buf.limit(1024 * (this.recordCount + 1));
            LineVectorDataSet result = new LineVectorDataSet(recBuffer, this.baseTime);
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Bad line: " + recordNumber + " file size=" + this.buf.capacity());
        }
    }

    public String getFileTitle() {
        return this.fileTitle.substring(0, 25);
    }

    public Datum getBaseTime() {
        return this.baseTime;
    }

    public class LineVectorDataSet
    extends EZVectorDataSet {
        double[] saveData = new double[1600];
        double baseUs2000;

        LineVectorDataSet(ByteBuffer recbuf, Datum baseTime) {
            int line = (recbuf.get(22) & 0xFF) << 8 | recbuf.get(23) & 0xFF;
            for (int i = 220; i < 1020; ++i) {
                double sample = (recbuf.get(i) & 0xF0) >>> 4 & 0xF;
                this.saveData[(i - 220) * 2] = sample - 7.5;
                sample = recbuf.get(i) & 0xF;
                this.saveData[(i - 220) * 2 + 1] = sample - 7.5;
            }
            this.baseUs2000 = baseTime.doubleValue(Units.us2000) + (double)((line - 1) * 60000);
            this.properties.put("baseTime", Units.us2000.createDatum(this.baseUs2000));
        }

        public double getDouble(int i, Units units) {
            return Units.dimensionless.convertDoubleTo(units, this.saveData[i]);
        }

        public int getXLength() {
            return 1600;
        }

        public double getXTagDouble(int i, Units units) {
            return Units.microseconds.convertDoubleTo(units, (double)i * 1000000.0 / 28800.0);
        }

        public Units getXUnits() {
            return Units.microseconds;
        }

        public Units getYUnits() {
            return Units.dimensionless;
        }
    }
}

