/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.DensityFileDataSetDescriptor;
import edu.uiowa.physics.pw.apps.vgpws_hr.HROptionsPanel;
import edu.uiowa.physics.pw.apps.vgpws_hr.VgDensDataDSD;
import edu.uiowa.physics.pw.apps.vgpws_hr.VoyagerHighRate;
import edu.uiowa.physics.pw.pds.PdsVolume;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.das2.DasException;
import org.das2.dataset.DataSetDescriptor;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.SeriesRenderer;
import org.das2.util.DasExceptionHandler;
import org.das2.util.filesystem.FileSystem;
import pds.label.PDSException;

public class DigitizerOverlaysSelector {
    JPanel overlaysPanel;
    VoyagerHighRate app;
    HROptionsPanel optionsPanel;
    private float lastHue = -0.07f;
    PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            DigitizerOverlaysSelector.this.refresh();
        }
    };
    PropertyChangeListener sclistener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            HROptionsPanel cfr_ignored_0 = DigitizerOverlaysSelector.this.optionsPanel;
            if (evt.getPropertyName().equals("voyager1")) {
                DigitizerOverlaysSelector.this.updateDSDs();
            }
        }
    };

    private Color getNextNonColorbarColor() {
        this.lastHue += 0.07f;
        return Color.getHSBColor(this.lastHue, 0.8f, 0.8f);
    }

    public JPanel getPanel() {
        return this.overlaysPanel;
    }

    private Component getOverlaySelector(final DensityFileDataSetDescriptor.SourceType source, final DensityFileDataSetDescriptor.PlaneType plane) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        final JCheckBox cb = new JCheckBox();
        result.add(cb);
        final JLabel symLabel = new JLabel();
        result.add(symLabel);
        cb.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String key = source.toString() + ":" + plane.toString();
                if (cb.isSelected()) {
                    SeriesRenderer r = (SeriesRenderer)DigitizerOverlaysSelector.this.app.overlayRenderers.get(key);
                    if (r == null) {
                        try {
                            DataSetDescriptor dsd;
                            r = new SeriesRenderer();
                            r.setLineWidth(1.0);
                            r.setPsym(DefaultPlotSymbol.NONE);
                            r.addPropertyChangeListener(DigitizerOverlaysSelector.this.listener);
                            if (source == DensityFileDataSetDescriptor.PDS_SOURCE_TYPE) {
                                PdsVolume vol = new PdsVolume(new URL("file:///opt/project/voyager/pds/VGPW_0201/"));
                                dsd = new VgDensDataDSD(vol, DigitizerOverlaysSelector.this.optionsPanel.isVoyager1() ? 1 : 2, plane);
                            } else if (source == DensityFileDataSetDescriptor.PDS_HTTP_SOURCE_TYPE) {
                                PdsVolume vol = new PdsVolume(new URL("http://www-pw.physics.uiowa.edu/~jbf/voyager/VGPW_0201/"));
                                dsd = new VgDensDataDSD(vol, DigitizerOverlaysSelector.this.optionsPanel.isVoyager1() ? 1 : 2, plane);
                            } else {
                                dsd = new DensityFileDataSetDescriptor(DigitizerOverlaysSelector.this.optionsPanel.isVoyager1() ? "1" : "2", source, plane);
                            }
                            r.setDataSetDescriptor(dsd);
                            r.setColor(DigitizerOverlaysSelector.this.getNextNonColorbarColor());
                            DigitizerOverlaysSelector.this.app.overlayRenderers.put(key, r);
                            DigitizerOverlaysSelector.this.app.overlayLabels.put(key, symLabel);
                            DigitizerOverlaysSelector.this.app.plot.addRenderer(r);
                            DigitizerOverlaysSelector.this.app.legend.add(r, key);
                            symLabel.setIcon(r.getListIcon());
                        }
                        catch (IOException ex) {
                            DasExceptionHandler.handle(ex);
                            return;
                        }
                        catch (PDSException ex) {
                            DasExceptionHandler.handle(ex);
                            return;
                        }
                        catch (DasException ex) {
                            DasExceptionHandler.handle(ex);
                            return;
                        }
                    } else {
                        DigitizerOverlaysSelector.this.app.legend.add(r, key);
                    }
                    r.setActive(true);
                } else {
                    SeriesRenderer r = (SeriesRenderer)DigitizerOverlaysSelector.this.app.overlayRenderers.get(key);
                    if (r != null) {
                        r.setActive(false);
                        DigitizerOverlaysSelector.this.app.legend.remove(r);
                    }
                }
            }
        });
        return result;
    }

    void initComponents() {
        Object[] sources = new Object[]{"", DensityFileDataSetDescriptor.P_SOURCE_TYPE, DensityFileDataSetDescriptor.L_SOURCE_TYPE, DensityFileDataSetDescriptor.U_SOURCE_TYPE, DensityFileDataSetDescriptor.R_SOURCE_TYPE, DensityFileDataSetDescriptor.INDEX_SOURCE_TYPE, DensityFileDataSetDescriptor.PDS_HTTP_SOURCE_TYPE};
        Object[] frequencies = new Object[]{"", DensityFileDataSetDescriptor.FPE_PLANE_TYPE, DensityFileDataSetDescriptor.FL_PLANE_TYPE, DensityFileDataSetDescriptor.FR_PLANE_TYPE, DensityFileDataSetDescriptor.FUH_PLANE_TYPE, DensityFileDataSetDescriptor.FCE_PLANE_TYPE};
        this.overlaysPanel = new JPanel();
        this.overlaysPanel.setPreferredSize(new Dimension(300, 300));
        this.overlaysPanel.setMaximumSize(new Dimension(300, 300));
        this.overlaysPanel.setLayout(new GridLayout(frequencies.length, sources.length));
        for (int j = 0; j < sources.length; ++j) {
            this.overlaysPanel.add(new JLabel(String.valueOf(sources[j])));
        }
        for (int i = 1; i < frequencies.length; ++i) {
            for (int j = 0; j < sources.length; ++j) {
                if (j == 0) {
                    this.overlaysPanel.add(new JLabel(String.valueOf(frequencies[i])));
                    continue;
                }
                this.overlaysPanel.add(this.getOverlaySelector((DensityFileDataSetDescriptor.SourceType)sources[j], (DensityFileDataSetDescriptor.PlaneType)frequencies[i]));
            }
        }
    }

    protected void refresh() {
        for (Object key : this.app.overlayRenderers.keySet()) {
            JLabel label = (JLabel)this.app.overlayLabels.get(key);
            SeriesRenderer rend = (SeriesRenderer)this.app.overlayRenderers.get(key);
            label.setIcon(rend.getListIcon());
        }
    }

    DigitizerOverlaysSelector(VoyagerHighRate app, HROptionsPanel optionsPanel) {
        this.app = app;
        this.optionsPanel = optionsPanel;
        optionsPanel.addPropertyChangeListener(this.sclistener);
        this.initComponents();
    }

    private void updateDSDs() {
        Set keys = this.app.overlayRenderers.keySet();
        for (Object o : keys) {
            SeriesRenderer r = (SeriesRenderer)this.app.overlayRenderers.get(o);
            DensityFileDataSetDescriptor dsd = (DensityFileDataSetDescriptor)r.getDataSetDescriptor();
            try {
                DensityFileDataSetDescriptor newdsd = new DensityFileDataSetDescriptor(this.optionsPanel.isVoyager1() ? "1" : "2", dsd.source, dsd.planeType);
                r.setDataSetDescriptor(newdsd);
            }
            catch (FileSystem.FileSystemOfflineException ex) {
                r.setException(ex);
            }
        }
    }
}

