/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import edu.uiowa.physics.pw.apps.vgpws_hr.DensityFileParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.das2.DasException;
import org.das2.dataset.CacheTag;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.DasExceptionHandler;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;

public class DensityFileDataSetDescriptor
extends DataSetDescriptor {
    FileStorageModelNew fsm;
    DensityFileParser parser;
    String plane;
    static HashMap sourceTypeInstances = new HashMap();
    SourceType source;
    PlaneType planeType;
    public static SourceType P_SOURCE_TYPE = new SourceType("p", "p_data");
    public static SourceType L_SOURCE_TYPE = new SourceType("L", "L_data");
    public static SourceType R_SOURCE_TYPE = new SourceType("R", "R_data");
    public static SourceType U_SOURCE_TYPE = new SourceType("u", "u_data");
    public static SourceType INDEX_SOURCE_TYPE = new SourceType("Index", "index_data");
    public static SourceType PDS_SOURCE_TYPE = new SourceType("PDS_LOCAL", "");
    public static SourceType PDS_HTTP_SOURCE_TYPE = new SourceType("PDS", "");
    static HashMap planeTypeInstances = new HashMap();
    public static PlaneType FPE_PLANE_TYPE = new PlaneType("fpe", "fpe");
    public static PlaneType FL_PLANE_TYPE = new PlaneType("f(L=0)", "f(L=0)");
    public static PlaneType FR_PLANE_TYPE = new PlaneType("f(R=0)", "f(R=0)");
    public static PlaneType FUH_PLANE_TYPE = new PlaneType("fuh", "fuh");
    public static PlaneType FCE_PLANE_TYPE = new PlaneType("fce", "fce");

    public DensityFileDataSetDescriptor(String voyagerNum, SourceType type, PlaneType plane) throws FileSystem.FileSystemOfflineException {
        FileSystem fs;
        try {
            fs = FileSystem.create(new URL("http://www-pw.physics.uiowa.edu/~jbf/voyager/" + type.dir + "/"));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        this.fsm = FileStorageModelNew.create(fs, "v" + voyagerNum + "den%Y%j.data");
        this.parser = new DensityFileParser();
        this.plane = plane.plane;
        this.planeType = plane;
        this.source = type;
    }

    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        DatumRange range = new DatumRange(start, end);
        try {
            File[] files = this.fsm.getFilesFor(range, monitor);
            DataSet result = null;
            for (int i = 0; i < files.length; ++i) {
                BufferedReader reader = new BufferedReader(new FileReader(files[i]));
                DataSet ds = this.parser.parse(reader);
                CacheTag ct = new CacheTag(this.fsm.getRangeFor(this.fsm.getNameFor(files[i])), null);
                result = DataSetUtil.append(result, ds, ct);
            }
            return result == null ? null : result.getPlanarView(this.plane);
        }
        catch (ParseException e) {
            throw new DasException(e.getMessage());
        }
        catch (IOException e) {
            throw new DasException(e.getMessage());
        }
    }

    public static DataSetDescriptor newDataSetDescriptor(Map properties) {
        try {
            SourceType source = (SourceType)sourceTypeInstances.get(properties.get("source"));
            PlaneType plane = (PlaneType)planeTypeInstances.get(properties.get("plane"));
            return new DensityFileDataSetDescriptor((String)properties.get("voyager"), source, plane);
        }
        catch (FileSystem.FileSystemOfflineException e) {
            DasExceptionHandler.handle(e);
            throw new RuntimeException(e);
        }
    }

    public Units getXUnits() {
        return Units.us2000;
    }

    public static void main(String[] args) throws Exception {
        DensityFileDataSetDescriptor dsd = new DensityFileDataSetDescriptor("1", P_SOURCE_TYPE, FUH_PLANE_TYPE);
        DatumRange range = DatumRangeUtil.parseTimeRangeValid("1979-060");
        DataSet ds = dsd.getDataSet(range.min(), range.max(), null, ProgressMonitor.NULL);
        System.out.println(ds);
    }

    public static class PlaneType {
        String type;
        String plane;

        PlaneType(String type, String plane) {
            this.type = type;
            this.plane = plane;
            planeTypeInstances.put(type, this);
        }

        public String toString() {
            return this.type;
        }
    }

    public static class SourceType {
        String type;
        String dir;

        SourceType(String type, String dir) {
            this.type = type;
            this.dir = dir;
            sourceTypeInstances.put(type, this);
        }

        public String toString() {
            return this.type;
        }
    }
}

