/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws_hr;

import java.awt.AWTException;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import org.das2.components.VerticalSpectrogramSlicer;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.event.CommentDataPointSelectionEvent;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.MousePointSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.util.DasDie;

public class DDCrossHairMouseModule
extends CrossHairMouseModule
implements KeyListener {
    MousePointSelectionEvent lastMousePoint;
    DasPlot parent;
    VerticalSpectrogramSlicer slicer;

    public DDCrossHairMouseModule(DasPlot parent, DasAxis xaxis, DasAxis yaxis) {
        this(parent, parent, xaxis, yaxis);
    }

    public DDCrossHairMouseModule(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent, dataSetConsumer, xAxis, yAxis);
        parent.addKeyListener(this);
        this.parent = parent;
        if (dataSetConsumer instanceof TableDataSetConsumer) {
            this.slicer = VerticalSpectrogramSlicer.createSlicer(parent, (TableDataSetConsumer)dataSetConsumer);
        }
    }

    public static CrossHairMouseModule create(DasPlot parent) {
        DasAxis xaxis = parent.getXAxis();
        DasAxis yaxis = parent.getYAxis();
        return new DDCrossHairMouseModule(parent, xaxis, yaxis);
    }

    public String getLabel() {
        return "KB Crosshair Digitizer";
    }

    public void mouseReleased(MouseEvent e) {
        this.lastMousePoint = null;
    }

    public void mousePointSelected(MousePointSelectionEvent e) {
        this.lastMousePoint = e;
        this.parent.requestFocus();
        if (this.slicer != null) {
            this.slicer.dataPointSelected(super.getDataPointSelectionEvent(e));
        }
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.lastMousePoint != null) {
            if (keyCode == 37 || keyCode == 39 || keyCode == 38 || keyCode == 40) {
                boolean x = false;
                boolean y = false;
                try {
                    int xOff = this.parent.getLocationOnScreen().x - this.parent.getX();
                    int yOff = this.parent.getLocationOnScreen().y - this.parent.getY();
                    Robot robot = new Robot();
                    switch (keyCode) {
                        case 37: {
                            robot.mouseMove(this.lastMousePoint.getX() + xOff - 1, this.lastMousePoint.getY() + yOff);
                            break;
                        }
                        case 39: {
                            robot.mouseMove(this.lastMousePoint.getX() + xOff + 1, this.lastMousePoint.getY() + yOff);
                            break;
                        }
                        case 38: {
                            robot.mouseMove(this.lastMousePoint.getX() + xOff, this.lastMousePoint.getY() + yOff - 1);
                            break;
                        }
                        case 40: {
                            robot.mouseMove(this.lastMousePoint.getX() + xOff, this.lastMousePoint.getY() + yOff + 1);
                        }
                    }
                }
                catch (AWTException e1) {
                    DasDie.println(e1.getMessage());
                }
            } else {
                DataPointSelectionEvent dpse = super.getDataPointSelectionEvent(this.lastMousePoint);
                super.fireDataPointSelectionListenerDataPointSelected(CommentDataPointSelectionEvent.create(dpse, "" + e.getKeyChar()));
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

