/*
 * Decompiled with CFR 0.152.
 */
package demos;

import edu.uiowa.physics.pw.pds.PdsBitColumn;
import edu.uiowa.physics.pw.pds.PdsColumn;
import edu.uiowa.physics.pw.pds.PdsFile;
import edu.uiowa.physics.pw.pds.PdsProduct;
import edu.uiowa.physics.pw.pds.PdsSeries;
import edu.uiowa.physics.pw.pds.PdsTable;
import edu.uiowa.physics.pw.pds.PdsVolume;
import edu.uiowa.physics.pw.pds.base.PdsRangeException;
import edu.uiowa.physics.pw.pds.catalog.PdsDataSet;
import edu.uiowa.physics.pw.pds.catalog.PdsDataSetInformation;
import edu.uiowa.physics.pw.pds.catalog.PdsDataSetMission;
import edu.uiowa.physics.pw.pds.catalog.PdsPersonnelInformation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import org.das2.util.filesystem.FileSystem;
import pds.label.PDSException;

public class Ex_VgrHighRate {
    public static void main(String[] argv) throws MalformedURLException, FileSystem.FileSystemOfflineException, FileNotFoundException, PDSException, IOException, PdsRangeException {
        char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        PdsVolume.g_allowedElements.add("MISSION_NAME");
        PdsVolume.g_allowedElements.add("SPACECRAFT_NAME");
        PdsBitColumn.g_allowedElements.add("SAMPLING_PARAMETER_NAME");
        PdsBitColumn.g_allowedElements.add("SAMPLING_PARAMETER_UNIT");
        PdsBitColumn.g_allowedElements.add("SAMPLING_PARAMETER_INTERVAL");
        PdsBitColumn.g_allowedElements.add("VALID_MINIMUM");
        PdsBitColumn.g_allowedElements.add("VALID_MAXIMUM");
        PdsDataSetInformation.g_reqElements.remove("ABSTRACT_DESC");
        PdsDataSetInformation.g_reqElements.remove("CITATION_DESC");
        PdsDataSetInformation.g_reqElements.remove("DATA_SET_TERSE_DESC");
        PdsDataSet.g_reqObjects.remove(PdsDataSetMission.class);
        PdsPersonnelInformation.g_allowedElements.add("NOTE");
        PdsVolume vol = new PdsVolume("file:///opt/project/voyager/pds/wfrm/VGPW_1001/");
        List<String> prodAry = vol.getProdByTimeRng("1978-001", "1978-233T05:42:24.300");
        for (String sRelPath : prodAry) {
            PdsProduct prod = vol.getProduct(sRelPath);
            PdsFile file = prod.getFile();
            String sDate = file.subTbl("ENGINEERING_TABLE").subCol("PWS_LABEL").getString();
            System.out.print(sDate.substring(0, sDate.length() - 2));
            System.out.print("\r\n");
            PdsTable table = file.subTbl("WF_ROW_PREFIX_TABLE");
            PdsColumn lineCol = table.subCol("FDS_LINE_COUNT");
            PdsSeries series = file.subSeries("TIME_SERIES");
            float fTimeStep = series.floatSingleVal("SAMPLING_PARAMETER_INTERVAL");
            PdsColumn col = series.subCol("WAVEFORM_BYTE");
            PdsBitColumn bitCol = col.subBitCol("WAVEFORM_SAMPLES");
            col.adjStartByte(-series.positiveSingleVal("ROW_PREFIX_BYTES"));
            if (!file.isLocal()) {
                System.out.println("Downloading: " + vol.getRootStr() + "/" + file.getDataRelPath());
                file.mkLocal();
            }
            char[] cLine = new char[col.size() * bitCol.size() + 1];
            cLine[1600] = 13;
            for (int i = 0; i < series.size(); ++i) {
                series.setRow(i);
                table.setRow(i);
                int nLine = lineCol.intVal();
                System.out.printf(" %03d %5.2f ", nLine, Float.valueOf((float)(nLine - 1) * fTimeStep));
                for (int j = 0; j < col.size(); ++j) {
                    col.setItem(j);
                    for (int k = 0; k < bitCol.size(); ++k) {
                        bitCol.item(k);
                        int n = bitCol.intVal();
                        cLine[j * bitCol.size() + k] = chars[n];
                    }
                }
                System.out.println(cLine);
            }
        }
    }
}

